/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c.handlers;

import io.ballerina.c2c.diagnostics.NullLocation;
import io.ballerina.c2c.exceptions.DockerGenException;
import io.ballerina.c2c.exceptions.KubernetesPluginException;
import io.ballerina.c2c.handlers.AbstractArtifactHandler;
import io.ballerina.c2c.util.C2CDiagnosticCodes;
import io.ballerina.c2c.utils.DockerGenerator;
import io.ballerina.c2c.utils.NativeDockerGenerator;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;

public class DockerHandler
extends AbstractArtifactHandler {
    private boolean isNative;

    public DockerHandler(boolean isNative) {
        this.isNative = isNative;
    }

    @Override
    public void createArtifacts() throws KubernetesPluginException {
        try {
            DockerGenerator dockerArtifactHandler = this.isNative ? new NativeDockerGenerator(this.dataHolder.getDockerModel()) : new DockerGenerator(this.dataHolder.getDockerModel());
            if (this.dataHolder.getDockerModel().isTest()) {
                dockerArtifactHandler.createTestArtifacts(OUT, "\t@kubernetes:Docker \t\t\t", this.dataHolder.getDockerArtifactOutputPath());
            } else {
                dockerArtifactHandler.createArtifacts(OUT, "\t@kubernetes:Docker \t\t\t", this.dataHolder.getJarPath(), this.dataHolder.getDockerArtifactOutputPath());
            }
        }
        catch (DockerGenException e) {
            DiagnosticInfo diagnosticInfo = new DiagnosticInfo(C2CDiagnosticCodes.DOCKER_FAILED.getCode(), e.getMessage(), DiagnosticSeverity.WARNING);
            Diagnostic diagnostic = DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)new NullLocation(), (Object[])new Object[0]);
            throw new KubernetesPluginException(diagnostic, true);
        }
    }
}

