/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c.handlers;

import io.ballerina.c2c.diagnostics.NullLocation;
import io.ballerina.c2c.exceptions.KubernetesPluginException;
import io.ballerina.c2c.handlers.AbstractArtifactHandler;
import io.ballerina.c2c.models.DeploymentModel;
import io.ballerina.c2c.models.PodAutoscalerModel;
import io.ballerina.c2c.util.C2CDiagnosticCodes;
import io.ballerina.c2c.utils.KubernetesUtils;
import io.ballerina.c2c.utils.TomlHelper;
import io.ballerina.toml.api.Toml;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.fabric8.kubernetes.api.model.autoscaling.v2.HorizontalPodAutoscaler;
import io.fabric8.kubernetes.api.model.autoscaling.v2.HorizontalPodAutoscalerBuilder;
import io.fabric8.kubernetes.api.model.autoscaling.v2.HorizontalPodAutoscalerFluent;
import io.fabric8.kubernetes.api.model.autoscaling.v2.MetricSpec;
import io.fabric8.kubernetes.api.model.autoscaling.v2.MetricSpecBuilder;
import io.fabric8.kubernetes.api.model.autoscaling.v2.MetricSpecFluent;
import io.fabric8.kubernetes.api.model.autoscaling.v2.ResourceMetricSourceFluent;
import java.io.IOException;
import java.util.ArrayList;

public class HPAHandler
extends AbstractArtifactHandler {
    private void generate(PodAutoscalerModel podAutoscalerModel) throws KubernetesPluginException {
        ArrayList<MetricSpec> metrics = new ArrayList<MetricSpec>();
        metrics.add(((MetricSpecBuilder)((MetricSpecFluent.ResourceNested)((ResourceMetricSourceFluent.TargetNested)((ResourceMetricSourceFluent.TargetNested)((MetricSpecFluent.ResourceNested)((MetricSpecBuilder)new MetricSpecBuilder().withType("Resource")).withNewResource().withName("cpu")).withNewTarget().withType("Utilization")).withAverageUtilization(podAutoscalerModel.getCpuPercentage())).endTarget()).endResource()).build());
        if (podAutoscalerModel.getMemoryPercentage() != 0) {
            metrics.add(((MetricSpecBuilder)((MetricSpecFluent.ResourceNested)((ResourceMetricSourceFluent.TargetNested)((ResourceMetricSourceFluent.TargetNested)((MetricSpecFluent.ResourceNested)((MetricSpecBuilder)new MetricSpecBuilder().withType("Resource")).withNewResource().withName("memory")).withNewTarget().withType("Utilization")).withAverageUtilization(podAutoscalerModel.getMemoryPercentage())).endTarget()).endResource()).build());
        }
        HorizontalPodAutoscaler horizontalPodAutoscaler = ((HorizontalPodAutoscalerBuilder)((HorizontalPodAutoscalerFluent.SpecNested)((HorizontalPodAutoscalerFluent.SpecNested)((HorizontalPodAutoscalerFluent.SpecNested)((HorizontalPodAutoscalerFluent.SpecNested)((HorizontalPodAutoscalerBuilder)((HorizontalPodAutoscalerFluent.MetadataNested)((HorizontalPodAutoscalerFluent.MetadataNested)((HorizontalPodAutoscalerFluent.MetadataNested)new HorizontalPodAutoscalerBuilder().withNewMetadata().withName(podAutoscalerModel.getName())).withNamespace(this.dataHolder.getNamespace())).withLabels(podAutoscalerModel.getLabels())).endMetadata()).withNewSpec().withMaxReplicas(podAutoscalerModel.getMaxReplicas())).withMinReplicas(podAutoscalerModel.getMinReplicas())).withMetrics(metrics)).withNewScaleTargetRef("apps/v1", "Deployment", podAutoscalerModel.getDeployment())).endSpec()).build();
        try {
            String hpaContent = KubernetesUtils.asYaml(horizontalPodAutoscaler);
            Object outputFileName = "_hpa.yaml";
            if (this.dataHolder.isSingleYaml()) {
                outputFileName = horizontalPodAutoscaler.getMetadata().getName() + ".yaml";
            }
            KubernetesUtils.writeToFile(hpaContent, (String)outputFileName);
        }
        catch (IOException e) {
            Diagnostic diagnostic = C2CDiagnosticCodes.createDiagnostic(C2CDiagnosticCodes.ARTIFACT_GEN_FAILED, new NullLocation(), "autoscaler", podAutoscalerModel.getName());
            throw new KubernetesPluginException(diagnostic);
        }
    }

    private void resolveToml(PodAutoscalerModel hpa) {
        Toml ballerinaCloud = this.dataHolder.getBallerinaCloud();
        if (ballerinaCloud != null) {
            String autoscaling = "cloud.deployment.autoscaling.";
            hpa.setMaxReplicas(Math.toIntExact(TomlHelper.getLong(ballerinaCloud, "cloud.deployment.autoscaling.max_replicas", hpa.getMaxReplicas())));
            hpa.setMinReplicas(Math.toIntExact(TomlHelper.getLong(ballerinaCloud, "cloud.deployment.autoscaling.min_replicas", hpa.getMinReplicas())));
            hpa.setCpuPercentage(Math.toIntExact(TomlHelper.getLong(ballerinaCloud, "cloud.deployment.autoscaling.cpu", hpa.getCpuPercentage())));
            hpa.setMemoryPercentage(Math.toIntExact(TomlHelper.getLong(ballerinaCloud, "cloud.deployment.autoscaling.memory", 0L)));
        }
    }

    @Override
    public void createArtifacts() throws KubernetesPluginException {
        DeploymentModel deploymentModel = this.dataHolder.getDeploymentModel();
        PodAutoscalerModel podAutoscalerModel = deploymentModel.getPodAutoscalerModel();
        if (!this.isHPAEnabled(podAutoscalerModel)) {
            return;
        }
        String balxFileName = this.dataHolder.getOutputName();
        podAutoscalerModel.addLabel("app", balxFileName);
        podAutoscalerModel.setDeployment(deploymentModel.getName());
        if (podAutoscalerModel.getMaxReplicas() == 0) {
            podAutoscalerModel.setMaxReplicas(deploymentModel.getReplicas() + 1);
        }
        if (podAutoscalerModel.getMinReplicas() == 0) {
            podAutoscalerModel.setMinReplicas(deploymentModel.getReplicas());
        }
        if (podAutoscalerModel.getName() == null || podAutoscalerModel.getName().length() == 0) {
            podAutoscalerModel.setName(KubernetesUtils.getValidName(balxFileName + "-hpa"));
        }
        this.resolveToml(podAutoscalerModel);
        this.generate(podAutoscalerModel);
        OUT.println("\t@kubernetes:HPA");
    }

    private boolean isHPAEnabled(PodAutoscalerModel podAutoscalerModel) {
        if (podAutoscalerModel == null) {
            return false;
        }
        Toml ballerinaCloud = this.dataHolder.getBallerinaCloud();
        if (ballerinaCloud == null) {
            return true;
        }
        return TomlHelper.getBoolean(ballerinaCloud, "cloud.deployment.autoscaling.enable", true);
    }
}

