/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c.handlers;

import io.ballerina.c2c.diagnostics.NullLocation;
import io.ballerina.c2c.exceptions.KubernetesPluginException;
import io.ballerina.c2c.handlers.AbstractArtifactHandler;
import io.ballerina.c2c.models.DeploymentModel;
import io.ballerina.c2c.models.ServiceModel;
import io.ballerina.c2c.util.C2CDiagnosticCodes;
import io.ballerina.c2c.utils.KubernetesUtils;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.ContainerPortBuilder;
import io.fabric8.kubernetes.api.model.Service;
import io.fabric8.kubernetes.api.model.ServiceBuilder;
import io.fabric8.kubernetes.api.model.ServiceFluent;
import io.fabric8.kubernetes.api.model.ServicePort;
import io.fabric8.kubernetes.api.model.ServicePortBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class ServiceHandler
extends AbstractArtifactHandler {
    private void generate(List<ServiceModel> serviceModels) throws KubernetesPluginException {
        if (serviceModels.isEmpty()) {
            return;
        }
        int count = 0;
        ServiceModel commonService = new ServiceModel();
        commonService.addLabel("app", this.dataHolder.getOutputName());
        commonService.setSelector(this.dataHolder.getOutputName());
        DeploymentModel deploymentModel = this.dataHolder.getDeploymentModel();
        if (deploymentModel.getInternalDomainName() != null) {
            commonService.setName(deploymentModel.getInternalDomainName());
        } else {
            commonService.setName(KubernetesUtils.getValidName(deploymentModel.getName().replace("-deployment", "") + "-svc"));
        }
        ArrayList<ServicePort> servicePorts = new ArrayList<ServicePort>();
        for (ServiceModel serviceModel : serviceModels) {
            ++count;
            if (null == serviceModel.getPortName()) {
                serviceModel.setPortName(KubernetesUtils.getValidName("port-" + count + "-" + commonService.getName()));
            }
            ServicePortBuilder servicePortBuilder = (ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)((ServicePortBuilder)new ServicePortBuilder().withName(serviceModel.getPortName())).withProtocol("TCP")).withPort(serviceModel.getPort())).withNewTargetPort(serviceModel.getTargetPort());
            servicePorts.add(servicePortBuilder.build());
            ContainerPort containerPort = ((ContainerPortBuilder)((ContainerPortBuilder)((ContainerPortBuilder)new ContainerPortBuilder().withName(serviceModel.getPortName())).withContainerPort(serviceModel.getTargetPort())).withProtocol("TCP")).build();
            deploymentModel.addPort(containerPort);
        }
        Service service = ((ServiceBuilder)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceFluent.SpecNested)((ServiceBuilder)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)((ServiceFluent.MetadataNested)new ServiceBuilder().withNewMetadata().withName(commonService.getName())).withNamespace(this.dataHolder.getNamespace())).addToLabels(commonService.getLabels())).endMetadata()).withNewSpec().withPorts(servicePorts)).addToSelector("app", commonService.getSelector())).withSessionAffinity(commonService.getSessionAffinity())).withType(commonService.getServiceType())).endSpec()).build();
        try {
            String serviceYAML = KubernetesUtils.asYaml(service);
            Object outputFileName = "_svc.yaml";
            if (this.dataHolder.isSingleYaml()) {
                outputFileName = service.getMetadata().getName() + ".yaml";
            }
            KubernetesUtils.writeToFile(serviceYAML, (String)outputFileName);
        }
        catch (IOException e) {
            Diagnostic diagnostic = C2CDiagnosticCodes.createDiagnostic(C2CDiagnosticCodes.ARTIFACT_GEN_FAILED, new NullLocation(), "service", commonService.getName());
            throw new KubernetesPluginException(diagnostic);
        }
    }

    @Override
    public void createArtifacts() throws KubernetesPluginException {
        this.generate(this.dataHolder.getServiceModelList());
        OUT.println("\t@kubernetes:Service");
    }
}

