/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c.models;

import io.ballerina.c2c.models.ConfigMapModel;
import io.ballerina.c2c.models.DeploymentModel;
import io.ballerina.c2c.models.DockerModel;
import io.ballerina.c2c.models.JobModel;
import io.ballerina.c2c.models.PodAutoscalerModel;
import io.ballerina.c2c.models.SecretModel;
import io.ballerina.c2c.models.ServiceModel;
import io.ballerina.toml.api.Toml;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.ballerinalang.model.elements.PackageID;

public class KubernetesDataHolder {
    private DeploymentModel deploymentModel;
    private DockerModel dockerModel;
    private PodAutoscalerModel podAutoscalerModel;
    private List<ServiceModel> serviceModelList = new ArrayList<ServiceModel>();
    private Set<SecretModel> secretModelSet = new HashSet<SecretModel>();
    private Set<ConfigMapModel> configMapModelSet = new HashSet<ConfigMapModel>();
    private JobModel jobModel;
    private Path jarPath;
    private Path k8sArtifactOutputPath;
    private Path dockerArtifactOutputPath;
    private Path choreoArtifactOutputPath;
    private String namespace;
    private Path sourceRoot;
    private PackageID packageID;
    private Toml ballerinaCloud = null;
    private boolean singleYaml = true;
    private String outputName;

    KubernetesDataHolder() {
        this.deploymentModel = new DeploymentModel();
        this.dockerModel = new DockerModel();
    }

    public void addSecrets(Set<SecretModel> secrets) {
        this.secretModelSet.addAll(secrets);
    }

    public void addConfigMaps(Set<ConfigMapModel> configMaps) {
        this.configMapModelSet.addAll(configMaps);
    }

    public void addServiceModel(ServiceModel serviceModel) {
        this.serviceModelList.add(serviceModel);
    }

    @Generated
    public DeploymentModel getDeploymentModel() {
        return this.deploymentModel;
    }

    @Generated
    public DockerModel getDockerModel() {
        return this.dockerModel;
    }

    @Generated
    public PodAutoscalerModel getPodAutoscalerModel() {
        return this.podAutoscalerModel;
    }

    @Generated
    public List<ServiceModel> getServiceModelList() {
        return this.serviceModelList;
    }

    @Generated
    public Set<SecretModel> getSecretModelSet() {
        return this.secretModelSet;
    }

    @Generated
    public Set<ConfigMapModel> getConfigMapModelSet() {
        return this.configMapModelSet;
    }

    @Generated
    public JobModel getJobModel() {
        return this.jobModel;
    }

    @Generated
    public Path getJarPath() {
        return this.jarPath;
    }

    @Generated
    public Path getK8sArtifactOutputPath() {
        return this.k8sArtifactOutputPath;
    }

    @Generated
    public Path getDockerArtifactOutputPath() {
        return this.dockerArtifactOutputPath;
    }

    @Generated
    public Path getChoreoArtifactOutputPath() {
        return this.choreoArtifactOutputPath;
    }

    @Generated
    public String getNamespace() {
        return this.namespace;
    }

    @Generated
    public Path getSourceRoot() {
        return this.sourceRoot;
    }

    @Generated
    public PackageID getPackageID() {
        return this.packageID;
    }

    @Generated
    public Toml getBallerinaCloud() {
        return this.ballerinaCloud;
    }

    @Generated
    public boolean isSingleYaml() {
        return this.singleYaml;
    }

    @Generated
    public String getOutputName() {
        return this.outputName;
    }

    @Generated
    public void setDeploymentModel(DeploymentModel deploymentModel) {
        this.deploymentModel = deploymentModel;
    }

    @Generated
    public void setDockerModel(DockerModel dockerModel) {
        this.dockerModel = dockerModel;
    }

    @Generated
    public void setPodAutoscalerModel(PodAutoscalerModel podAutoscalerModel) {
        this.podAutoscalerModel = podAutoscalerModel;
    }

    @Generated
    public void setServiceModelList(List<ServiceModel> serviceModelList) {
        this.serviceModelList = serviceModelList;
    }

    @Generated
    public void setSecretModelSet(Set<SecretModel> secretModelSet) {
        this.secretModelSet = secretModelSet;
    }

    @Generated
    public void setConfigMapModelSet(Set<ConfigMapModel> configMapModelSet) {
        this.configMapModelSet = configMapModelSet;
    }

    @Generated
    public void setJobModel(JobModel jobModel) {
        this.jobModel = jobModel;
    }

    @Generated
    public void setJarPath(Path jarPath) {
        this.jarPath = jarPath;
    }

    @Generated
    public void setK8sArtifactOutputPath(Path k8sArtifactOutputPath) {
        this.k8sArtifactOutputPath = k8sArtifactOutputPath;
    }

    @Generated
    public void setDockerArtifactOutputPath(Path dockerArtifactOutputPath) {
        this.dockerArtifactOutputPath = dockerArtifactOutputPath;
    }

    @Generated
    public void setChoreoArtifactOutputPath(Path choreoArtifactOutputPath) {
        this.choreoArtifactOutputPath = choreoArtifactOutputPath;
    }

    @Generated
    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    @Generated
    public void setSourceRoot(Path sourceRoot) {
        this.sourceRoot = sourceRoot;
    }

    @Generated
    public void setPackageID(PackageID packageID) {
        this.packageID = packageID;
    }

    @Generated
    public void setBallerinaCloud(Toml ballerinaCloud) {
        this.ballerinaCloud = ballerinaCloud;
    }

    @Generated
    public void setSingleYaml(boolean singleYaml) {
        this.singleYaml = singleYaml;
    }

    @Generated
    public void setOutputName(String outputName) {
        this.outputName = outputName;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KubernetesDataHolder)) {
            return false;
        }
        KubernetesDataHolder other = (KubernetesDataHolder)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isSingleYaml() != other.isSingleYaml()) {
            return false;
        }
        DeploymentModel this$deploymentModel = this.getDeploymentModel();
        DeploymentModel other$deploymentModel = other.getDeploymentModel();
        if (this$deploymentModel == null ? other$deploymentModel != null : !((Object)this$deploymentModel).equals(other$deploymentModel)) {
            return false;
        }
        DockerModel this$dockerModel = this.getDockerModel();
        DockerModel other$dockerModel = other.getDockerModel();
        if (this$dockerModel == null ? other$dockerModel != null : !this$dockerModel.equals(other$dockerModel)) {
            return false;
        }
        PodAutoscalerModel this$podAutoscalerModel = this.getPodAutoscalerModel();
        PodAutoscalerModel other$podAutoscalerModel = other.getPodAutoscalerModel();
        if (this$podAutoscalerModel == null ? other$podAutoscalerModel != null : !((Object)this$podAutoscalerModel).equals(other$podAutoscalerModel)) {
            return false;
        }
        List<ServiceModel> this$serviceModelList = this.getServiceModelList();
        List<ServiceModel> other$serviceModelList = other.getServiceModelList();
        if (this$serviceModelList == null ? other$serviceModelList != null : !((Object)this$serviceModelList).equals(other$serviceModelList)) {
            return false;
        }
        Set<SecretModel> this$secretModelSet = this.getSecretModelSet();
        Set<SecretModel> other$secretModelSet = other.getSecretModelSet();
        if (this$secretModelSet == null ? other$secretModelSet != null : !((Object)this$secretModelSet).equals(other$secretModelSet)) {
            return false;
        }
        Set<ConfigMapModel> this$configMapModelSet = this.getConfigMapModelSet();
        Set<ConfigMapModel> other$configMapModelSet = other.getConfigMapModelSet();
        if (this$configMapModelSet == null ? other$configMapModelSet != null : !((Object)this$configMapModelSet).equals(other$configMapModelSet)) {
            return false;
        }
        JobModel this$jobModel = this.getJobModel();
        JobModel other$jobModel = other.getJobModel();
        if (this$jobModel == null ? other$jobModel != null : !((Object)this$jobModel).equals(other$jobModel)) {
            return false;
        }
        Path this$jarPath = this.getJarPath();
        Path other$jarPath = other.getJarPath();
        if (this$jarPath == null ? other$jarPath != null : !((Object)this$jarPath).equals(other$jarPath)) {
            return false;
        }
        Path this$k8sArtifactOutputPath = this.getK8sArtifactOutputPath();
        Path other$k8sArtifactOutputPath = other.getK8sArtifactOutputPath();
        if (this$k8sArtifactOutputPath == null ? other$k8sArtifactOutputPath != null : !((Object)this$k8sArtifactOutputPath).equals(other$k8sArtifactOutputPath)) {
            return false;
        }
        Path this$dockerArtifactOutputPath = this.getDockerArtifactOutputPath();
        Path other$dockerArtifactOutputPath = other.getDockerArtifactOutputPath();
        if (this$dockerArtifactOutputPath == null ? other$dockerArtifactOutputPath != null : !((Object)this$dockerArtifactOutputPath).equals(other$dockerArtifactOutputPath)) {
            return false;
        }
        Path this$choreoArtifactOutputPath = this.getChoreoArtifactOutputPath();
        Path other$choreoArtifactOutputPath = other.getChoreoArtifactOutputPath();
        if (this$choreoArtifactOutputPath == null ? other$choreoArtifactOutputPath != null : !((Object)this$choreoArtifactOutputPath).equals(other$choreoArtifactOutputPath)) {
            return false;
        }
        String this$namespace = this.getNamespace();
        String other$namespace = other.getNamespace();
        if (this$namespace == null ? other$namespace != null : !this$namespace.equals(other$namespace)) {
            return false;
        }
        Path this$sourceRoot = this.getSourceRoot();
        Path other$sourceRoot = other.getSourceRoot();
        if (this$sourceRoot == null ? other$sourceRoot != null : !((Object)this$sourceRoot).equals(other$sourceRoot)) {
            return false;
        }
        PackageID this$packageID = this.getPackageID();
        PackageID other$packageID = other.getPackageID();
        if (this$packageID == null ? other$packageID != null : !this$packageID.equals(other$packageID)) {
            return false;
        }
        Toml this$ballerinaCloud = this.getBallerinaCloud();
        Toml other$ballerinaCloud = other.getBallerinaCloud();
        if (this$ballerinaCloud == null ? other$ballerinaCloud != null : !this$ballerinaCloud.equals(other$ballerinaCloud)) {
            return false;
        }
        String this$outputName = this.getOutputName();
        String other$outputName = other.getOutputName();
        return !(this$outputName == null ? other$outputName != null : !this$outputName.equals(other$outputName));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof KubernetesDataHolder;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isSingleYaml() ? 79 : 97);
        DeploymentModel $deploymentModel = this.getDeploymentModel();
        result = result * 59 + ($deploymentModel == null ? 43 : ((Object)$deploymentModel).hashCode());
        DockerModel $dockerModel = this.getDockerModel();
        result = result * 59 + ($dockerModel == null ? 43 : $dockerModel.hashCode());
        PodAutoscalerModel $podAutoscalerModel = this.getPodAutoscalerModel();
        result = result * 59 + ($podAutoscalerModel == null ? 43 : ((Object)$podAutoscalerModel).hashCode());
        List<ServiceModel> $serviceModelList = this.getServiceModelList();
        result = result * 59 + ($serviceModelList == null ? 43 : ((Object)$serviceModelList).hashCode());
        Set<SecretModel> $secretModelSet = this.getSecretModelSet();
        result = result * 59 + ($secretModelSet == null ? 43 : ((Object)$secretModelSet).hashCode());
        Set<ConfigMapModel> $configMapModelSet = this.getConfigMapModelSet();
        result = result * 59 + ($configMapModelSet == null ? 43 : ((Object)$configMapModelSet).hashCode());
        JobModel $jobModel = this.getJobModel();
        result = result * 59 + ($jobModel == null ? 43 : ((Object)$jobModel).hashCode());
        Path $jarPath = this.getJarPath();
        result = result * 59 + ($jarPath == null ? 43 : ((Object)$jarPath).hashCode());
        Path $k8sArtifactOutputPath = this.getK8sArtifactOutputPath();
        result = result * 59 + ($k8sArtifactOutputPath == null ? 43 : ((Object)$k8sArtifactOutputPath).hashCode());
        Path $dockerArtifactOutputPath = this.getDockerArtifactOutputPath();
        result = result * 59 + ($dockerArtifactOutputPath == null ? 43 : ((Object)$dockerArtifactOutputPath).hashCode());
        Path $choreoArtifactOutputPath = this.getChoreoArtifactOutputPath();
        result = result * 59 + ($choreoArtifactOutputPath == null ? 43 : ((Object)$choreoArtifactOutputPath).hashCode());
        String $namespace = this.getNamespace();
        result = result * 59 + ($namespace == null ? 43 : $namespace.hashCode());
        Path $sourceRoot = this.getSourceRoot();
        result = result * 59 + ($sourceRoot == null ? 43 : ((Object)$sourceRoot).hashCode());
        PackageID $packageID = this.getPackageID();
        result = result * 59 + ($packageID == null ? 43 : $packageID.hashCode());
        Toml $ballerinaCloud = this.getBallerinaCloud();
        result = result * 59 + ($ballerinaCloud == null ? 43 : $ballerinaCloud.hashCode());
        String $outputName = this.getOutputName();
        result = result * 59 + ($outputName == null ? 43 : $outputName.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "KubernetesDataHolder(deploymentModel=" + String.valueOf(this.getDeploymentModel()) + ", dockerModel=" + String.valueOf(this.getDockerModel()) + ", podAutoscalerModel=" + String.valueOf(this.getPodAutoscalerModel()) + ", serviceModelList=" + String.valueOf(this.getServiceModelList()) + ", secretModelSet=" + String.valueOf(this.getSecretModelSet()) + ", configMapModelSet=" + String.valueOf(this.getConfigMapModelSet()) + ", jobModel=" + String.valueOf(this.getJobModel()) + ", jarPath=" + String.valueOf(this.getJarPath()) + ", k8sArtifactOutputPath=" + String.valueOf(this.getK8sArtifactOutputPath()) + ", dockerArtifactOutputPath=" + String.valueOf(this.getDockerArtifactOutputPath()) + ", choreoArtifactOutputPath=" + String.valueOf(this.getChoreoArtifactOutputPath()) + ", namespace=" + this.getNamespace() + ", sourceRoot=" + String.valueOf(this.getSourceRoot()) + ", packageID=" + String.valueOf(this.getPackageID()) + ", ballerinaCloud=" + String.valueOf(this.getBallerinaCloud()) + ", singleYaml=" + this.isSingleYaml() + ", outputName=" + this.getOutputName() + ")";
    }
}

