/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c.tasks;

import io.ballerina.c2c.diagnostics.TomlDiagnosticChecker;
import io.ballerina.c2c.utils.KubernetesUtils;
import io.ballerina.c2c.utils.TomlHelper;
import io.ballerina.projects.CloudToml;
import io.ballerina.projects.Project;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.CompilationAnalysisContext;
import io.ballerina.toml.api.Toml;
import io.ballerina.toml.validator.TomlValidator;
import io.ballerina.toml.validator.schema.Schema;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.MissingResourceException;
import java.util.Optional;
import org.apache.commons.io.IOUtils;

public class CloudTomlAnalysisTask
implements AnalysisTask<CompilationAnalysisContext> {
    public void perform(CompilationAnalysisContext compilationAnalysisContext) {
        Project project = compilationAnalysisContext.currentPackage().project();
        String cloud = project.buildOptions().cloud();
        if (cloud == null || !KubernetesUtils.isBuildOptionDockerOrK8s(cloud)) {
            return;
        }
        TomlDiagnosticChecker tomlDiagnosticChecker = new TomlDiagnosticChecker(project);
        Optional cloudToml = project.currentPackage().cloudToml();
        if (cloudToml.isEmpty()) {
            return;
        }
        Toml toml = TomlHelper.createK8sTomlFromProject(((CloudToml)cloudToml.get()).tomlDocument());
        TomlValidator validator = new TomlValidator(Schema.from((String)this.getValidationSchema()));
        validator.validate(toml);
        List diagnostics = toml.diagnostics();
        diagnostics.addAll(tomlDiagnosticChecker.validateTomlWithSource(toml));
        diagnostics.forEach(arg_0 -> ((CompilationAnalysisContext)compilationAnalysisContext).reportDiagnostic(arg_0));
    }

    private String getValidationSchema() {
        try {
            InputStream inputStream = this.getClass().getClassLoader().getResourceAsStream("c2c-schema.json");
            if (inputStream == null) {
                throw new MissingResourceException("Schema Not found", "c2c-schema.json", "");
            }
            StringWriter writer = new StringWriter();
            IOUtils.copy((InputStream)inputStream, (Writer)writer, (String)StandardCharsets.UTF_8.name());
            return writer.toString();
        }
        catch (IOException e) {
            throw new MissingResourceException("Schema Not found", "c2c-schema.json", "");
        }
    }
}

