/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.c2c.utils;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import io.ballerina.c2c.diagnostics.NullLocation;
import io.ballerina.c2c.exceptions.DockerGenException;
import io.ballerina.c2c.exceptions.KubernetesPluginException;
import io.ballerina.c2c.models.ConfigMapModel;
import io.ballerina.c2c.models.CopyFileModel;
import io.ballerina.c2c.models.DeploymentModel;
import io.ballerina.c2c.models.DockerModel;
import io.ballerina.c2c.models.JobModel;
import io.ballerina.c2c.models.KubernetesContext;
import io.ballerina.c2c.models.KubernetesDataHolder;
import io.ballerina.c2c.models.KubernetesModel;
import io.ballerina.c2c.models.SecretModel;
import io.ballerina.c2c.util.C2CDiagnosticCodes;
import io.ballerina.c2c.utils.DockerGenUtils;
import io.ballerina.c2c.utils.TomlHelper;
import io.ballerina.cli.utils.DebugUtils;
import io.ballerina.projects.Package;
import io.ballerina.toml.api.Toml;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import io.fabric8.kubernetes.api.model.ContainerPort;
import io.fabric8.kubernetes.api.model.VolumeMount;
import io.fabric8.kubernetes.api.model.VolumeMountBuilder;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.ballerinalang.model.elements.PackageID;
import org.wso2.ballerinalang.compiler.util.Name;

public class KubernetesUtils {
    private static final PrintStream ERR = System.err;
    private static final PrintStream OUT = System.out;
    private static final ObjectMapper YAML_MAPPER = new ObjectMapper((JsonFactory)new YAMLFactory().disable(YAMLGenerator.Feature.USE_NATIVE_TYPE_ID));

    public static void writeToFile(String context, String outputFileName) throws IOException {
        KubernetesDataHolder dataHolder = KubernetesContext.getInstance().getDataHolder();
        KubernetesUtils.writeToFile(dataHolder.getK8sArtifactOutputPath(), context, outputFileName);
    }

    public static void writeToFile(Path outputDir, String context, String fileSuffix) throws IOException {
        KubernetesDataHolder dataHolder = KubernetesContext.getInstance().getDataHolder();
        String outputName = dataHolder.getOutputName();
        Path artifactFileName = outputDir.resolve(outputName + fileSuffix);
        DeploymentModel deploymentModel = dataHolder.getDeploymentModel();
        JobModel jobModel = dataHolder.getJobModel();
        if (jobModel != null && dataHolder.isSingleYaml()) {
            artifactFileName = outputDir.resolve(outputName + ".yaml");
        } else if (jobModel == null && deploymentModel != null && dataHolder.isSingleYaml()) {
            artifactFileName = outputDir.resolve(outputName + ".yaml");
        }
        File newFile = artifactFileName.toFile();
        if (newFile.exists()) {
            Files.write(artifactFileName, context.getBytes(StandardCharsets.UTF_8), StandardOpenOption.APPEND);
            return;
        }
        if (newFile.getParentFile().mkdirs()) {
            Files.write(artifactFileName, context.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            return;
        }
        Files.write(artifactFileName, context.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
    }

    public static byte[] readFileContent(Path targetFilePath) throws KubernetesPluginException {
        return KubernetesUtils.readFileContent(targetFilePath, C2CDiagnosticCodes.PATH_CONTENT_READ_FAILED);
    }

    public static byte[] readFileContent(Path targetFilePath, C2CDiagnosticCodes code) throws KubernetesPluginException {
        File file = targetFilePath.toFile();
        if (file.exists() && !file.isDirectory()) {
            try {
                return Files.readAllBytes(targetFilePath);
            }
            catch (IOException e) {
                Diagnostic diagnostic = C2CDiagnosticCodes.createDiagnostic(code, new NullLocation(), targetFilePath);
                throw new KubernetesPluginException(diagnostic);
            }
        }
        Diagnostic diagnostic = C2CDiagnosticCodes.createDiagnostic(code, new NullLocation(), targetFilePath);
        throw new KubernetesPluginException(diagnostic);
    }

    public static void printError(String msg) {
        ERR.println("error [k8s plugin]: " + msg);
    }

    public static void printInstruction(String msg) {
        OUT.println(msg);
    }

    public static void deleteDirectory(Path path) throws KubernetesPluginException {
        Path pathToBeDeleted = path.toAbsolutePath();
        if (!Files.exists(pathToBeDeleted, new LinkOption[0])) {
            return;
        }
        try {
            Files.walk(pathToBeDeleted, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
        }
        catch (IOException e) {
            Diagnostic diagnostic = C2CDiagnosticCodes.createDiagnostic(C2CDiagnosticCodes.DIRECTORY_DELETE_FAILED, new NullLocation(), path.toString());
            throw new KubernetesPluginException(diagnostic);
        }
    }

    public static boolean isBlank(String str) {
        int strLen;
        if (str != null && (strLen = str.length()) != 0) {
            for (int i = 0; i < strLen; ++i) {
                if (Character.isWhitespace(str.charAt(i))) continue;
                return false;
            }
        }
        return true;
    }

    public static String getValidName(String name) {
        if (name.startsWith("/")) {
            name = name.substring(1);
        }
        name = name.toLowerCase(Locale.getDefault()).replaceAll("[_.]", "-").replaceAll("[$]", "").replaceAll("/", "-").replaceAll("--", "-");
        if ((name = name.substring(0, Math.min(name.length(), 15))).endsWith("-")) {
            return name.substring(0, name.length() - 1);
        }
        return name;
    }

    public static PackageID getProjectID(Package currentPackage) {
        return new PackageID(new Name(currentPackage.packageOrg().value()), new Name(currentPackage.packageName().value()), new Name(currentPackage.packageVersion().value().toString()));
    }

    public static Optional<String> getExtension(String filename) {
        return Optional.ofNullable(filename).filter(f -> f.contains(".")).map(f -> f.substring(filename.lastIndexOf(".") + 1));
    }

    public static String getFileNameOfSecret(SecretModel secretModel) {
        Map<String, String> data = secretModel.getData();
        return data.keySet().iterator().next();
    }

    public static String getFileNameOfConfigMap(ConfigMapModel configMapModel) {
        Map<String, String> data = configMapModel.getData();
        return data.keySet().iterator().next();
    }

    public static void resolveDockerToml(KubernetesModel model) throws KubernetesPluginException {
        KubernetesDataHolder dataHolder = KubernetesContext.getInstance().getDataHolder();
        String containerImage = "container.image";
        Toml toml = dataHolder.getBallerinaCloud();
        DockerModel dockerModel = dataHolder.getDockerModel();
        dockerModel.setJarFileName(DockerGenUtils.extractJarName(dataHolder.getJarPath()) + ".jar");
        String fatJarFileName = dockerModel.getFatJarPath().getFileName().toString();
        String executableName = fatJarFileName.replaceFirst(".jar", "");
        StringBuilder defaultBuilderCmd = new StringBuilder().append("native-image ");
        if (!dockerModel.getGraalvmBuildArgs().equals("")) {
            defaultBuilderCmd.append(dockerModel.getGraalvmBuildArgs()).append(" ");
        }
        defaultBuilderCmd.append("-jar ").append(fatJarFileName).append(" -o ").append(executableName).append(" --no-fallback");
        if (!dockerModel.getGraalvmBuildArgs().contains("--static")) {
            defaultBuilderCmd.append(" -H:+StaticExecutableWithDynamicLibC");
        }
        dockerModel.setBuilderCmd(defaultBuilderCmd.toString());
        String defaultBaseImage = "ballerina/jvm-runtime:3.0";
        if (dockerModel.isGraalVMBuild()) {
            defaultBaseImage = "gcr.io/distroless/cc";
        }
        dockerModel.setBaseImage(defaultBaseImage);
        if (toml != null) {
            dockerModel.setRegistry(TomlHelper.getString(toml, "container.image.repository", null));
            dockerModel.setTag(TomlHelper.getString(toml, "container.image.tag", dockerModel.getTag()));
            dockerModel.setBaseImage(TomlHelper.getString(toml, "container.image.base", defaultBaseImage));
            dockerModel.setEntryPoint(TomlHelper.getString(toml, "container.image.entrypoint", dockerModel.getEntryPoint()));
            if (model instanceof DeploymentModel) {
                dockerModel.setName(TomlHelper.getString(toml, "container.image.name", model.getName().replace("-deployment", "")));
                imageName = KubernetesUtils.isBlank(dockerModel.getRegistry()) ? dockerModel.getName() + ":" + dockerModel.getTag() : dockerModel.getRegistry() + "/" + dockerModel.getName() + ":" + dockerModel.getTag();
                ((DeploymentModel)model).setImage(imageName);
            } else {
                dockerModel.setName(TomlHelper.getString(toml, "container.image.name", model.getName().replace("-job", "")));
                imageName = KubernetesUtils.isBlank(dockerModel.getRegistry()) ? dockerModel.getName() + ":" + dockerModel.getTag() : dockerModel.getRegistry() + "/" + dockerModel.getName() + ":" + dockerModel.getTag();
                ((JobModel)model).setImage(imageName);
            }
            dockerModel.setBuildImage(TomlHelper.getBoolean(toml, "settings.buildImage", true));
            HashSet<CopyFileModel> copyFiles = new HashSet<CopyFileModel>();
            for (Toml entry : toml.getTables("container.copy.files")) {
                CopyFileModel copyFileModel = new CopyFileModel();
                copyFileModel.setSource(TomlHelper.getString(entry, "sourceFile"));
                copyFileModel.setTarget(TomlHelper.getString(entry, "target"));
                copyFiles.add(copyFileModel);
            }
            dockerModel.setThinJar(KubernetesUtils.isThinJar(toml, dockerModel));
            dockerModel.setBuilderBase(TomlHelper.getString(toml, "graalvm.builder.base", "ghcr.io/graalvm/native-image-community:21-ol9"));
            dockerModel.setBuilderCmd(TomlHelper.getString(toml, "graalvm.builder.buildCmd", defaultBuilderCmd.toString()));
            try {
                dockerModel.setCopyFiles(copyFiles);
            }
            catch (DockerGenException e) {
                DiagnosticInfo diagnosticInfo = new DiagnosticInfo(C2CDiagnosticCodes.DOCKER_FAILED.getCode(), e.getMessage(), DiagnosticSeverity.WARNING);
                Diagnostic diagnostic = DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)new NullLocation(), (Object[])new Object[0]);
                throw new KubernetesPluginException(diagnostic);
            }
        }
    }

    public static DockerModel getDockerModel(DeploymentModel deploymentModel) {
        KubernetesDataHolder dataHolder = KubernetesContext.getInstance().getDataHolder();
        DockerModel dockerModel = dataHolder.getDockerModel();
        String dockerImage = deploymentModel.getImage();
        String imageTag = "latest";
        if (dockerImage.contains(":")) {
            imageTag = dockerImage.substring(dockerImage.lastIndexOf(":") + 1);
            dockerImage = dockerImage.substring(0, dockerImage.lastIndexOf(":"));
        }
        dockerModel.setJarFileName(DockerGenUtils.extractJarName(dataHolder.getJarPath()) + ".jar");
        dockerModel.setPkgId(dataHolder.getPackageID());
        dockerModel.setRegistry(deploymentModel.getRegistry());
        dockerModel.setName(dockerImage);
        dockerModel.setTag(imageTag);
        if (!dockerModel.isTest()) {
            dockerModel.setService(true);
            dockerModel.setPorts(deploymentModel.getPorts().stream().map(ContainerPort::getContainerPort).collect(Collectors.toSet()));
        } else {
            dockerModel.setService(false);
            dockerModel.setPorts(Collections.emptySet());
        }
        dockerModel.addCommandArg(deploymentModel.getCommandArgs());
        return dockerModel;
    }

    public static boolean isBuildOptionDockerOrK8s(String buildOption) {
        switch (buildOption) {
            case "k8s": 
            case "docker": {
                return true;
            }
        }
        return false;
    }

    public static <T> String asYaml(T object) throws KubernetesPluginException {
        try {
            return YAML_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            DiagnosticInfo diagnosticInfo = new DiagnosticInfo(C2CDiagnosticCodes.ARTIFACT_GEN_FAILED.getCode(), e.getMessage(), DiagnosticSeverity.WARNING);
            throw new KubernetesPluginException(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)new NullLocation(), (Object[])new Object[0]));
        }
    }

    public static boolean isThinJar(Toml ballerinaCloud, DockerModel dockerModel) {
        if (!TomlHelper.getBoolean(ballerinaCloud, "settings.thinJar", true)) {
            return false;
        }
        return dockerModel.getDependencyJarPaths().size() + dockerModel.getCopyFiles().size() + dockerModel.getEnv().size() < 110;
    }

    public static List<VolumeMount> generateConfigMapVolumeMounts(Collection<ConfigMapModel> configMapModels) {
        ArrayList<VolumeMount> volumeMounts = new ArrayList<VolumeMount>();
        for (ConfigMapModel configMapModel : configMapModels) {
            String mountPath = configMapModel.getMountPath();
            VolumeMountBuilder volumeMountBuilder = (VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withMountPath(mountPath)).withName(configMapModel.getName() + "-volume")).withReadOnly(configMapModel.isReadOnly());
            if (!configMapModel.isDir() && !configMapModel.isBallerinaConf()) {
                volumeMountBuilder.withSubPath(KubernetesUtils.getFileNameOfConfigMap(configMapModel));
            }
            volumeMounts.add(volumeMountBuilder.build());
        }
        return volumeMounts;
    }

    public static List<VolumeMount> generateSecretVolumeMounts(Collection<SecretModel> secretModels) {
        ArrayList<VolumeMount> volumeMounts = new ArrayList<VolumeMount>();
        for (SecretModel secretModel : secretModels) {
            VolumeMountBuilder volumeMountBuilder = (VolumeMountBuilder)((VolumeMountBuilder)((VolumeMountBuilder)new VolumeMountBuilder().withMountPath(secretModel.getMountPath())).withName(secretModel.getName() + "-volume")).withReadOnly(secretModel.isReadOnly());
            if (!secretModel.isDir() && !secretModel.isBallerinaConf()) {
                volumeMountBuilder.withSubPath(KubernetesUtils.getFileNameOfSecret(secretModel));
            }
            VolumeMount volumeMount = volumeMountBuilder.build();
            volumeMounts.add(volumeMount);
        }
        return volumeMounts;
    }

    public static void validateFileExistence(File file) throws KubernetesPluginException {
        if (!file.exists()) {
            Diagnostic diagnostic = C2CDiagnosticCodes.createDiagnostic(C2CDiagnosticCodes.PATH_CONTENT_READ_FAILED, new NullLocation(), file.getAbsolutePath());
            throw new KubernetesPluginException(diagnostic);
        }
    }

    public static void runCommand(String dockerImage) {
        ProcessBuilder processBuilder;
        if (DebugUtils.isInDebugMode()) {
            String debugPort = System.getProperty("debug");
            processBuilder = new ProcessBuilder("docker", "run", "--rm", "-p", debugPort + ":" + debugPort, dockerImage);
        } else {
            processBuilder = new ProcessBuilder("docker", "run", "--rm", dockerImage);
        }
        int exitCode = KubernetesUtils.executeProcess(processBuilder);
        if (exitCode != 0) {
            KubernetesUtils.printError("Error running the docker image: " + dockerImage);
        }
    }

    private static int executeProcess(ProcessBuilder processBuilder) {
        try {
            Process process = processBuilder.start();
            InputStream inputStream = process.getInputStream();
            InputStream errorStream = process.getErrorStream();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (line.contains("Untagged") || line.contains("Deleted")) continue;
                    OUT.println(line);
                }
            }
            try (BufferedReader errorReader = new BufferedReader(new InputStreamReader(errorStream));){
                String errorLine;
                while ((errorLine = errorReader.readLine()) != null) {
                    ERR.println(errorLine);
                }
            }
            return process.waitFor();
        }
        catch (IOException | InterruptedException e) {
            KubernetesUtils.printError("Error executing the process: " + String.valueOf(processBuilder.command()));
            return -1;
        }
    }

    public static void deleteDockerImage(String imageName) {
        ProcessBuilder processBuilder = new ProcessBuilder("docker", "rmi", imageName);
        int exitCode = KubernetesUtils.executeProcess(processBuilder);
        if (exitCode != 0) {
            KubernetesUtils.printError("Error deleting the docker image: " + imageName);
        }
    }
}

