/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STStatementNode;
import io.ballerina.compiler.syntax.tree.DoStatementNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STDoStatementNode
extends STStatementNode {
    public final STNode doKeyword;
    public final STNode blockStatement;
    public final STNode onFailClause;

    STDoStatementNode(STNode doKeyword, STNode blockStatement, STNode onFailClause) {
        this(doKeyword, blockStatement, onFailClause, Collections.emptyList());
    }

    STDoStatementNode(STNode doKeyword, STNode blockStatement, STNode onFailClause, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.DO_STATEMENT, diagnostics);
        this.doKeyword = doKeyword;
        this.blockStatement = blockStatement;
        this.onFailClause = onFailClause;
        this.addChildren(doKeyword, blockStatement, onFailClause);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STDoStatementNode(this.doKeyword, this.blockStatement, this.onFailClause, diagnostics);
    }

    public STDoStatementNode modify(STNode doKeyword, STNode blockStatement, STNode onFailClause) {
        if (this.checkForReferenceEquality(doKeyword, blockStatement, onFailClause)) {
            return this;
        }
        return new STDoStatementNode(doKeyword, blockStatement, onFailClause, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new DoStatementNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

