/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STBindingPatternNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.ErrorBindingPatternNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STErrorBindingPatternNode
extends STBindingPatternNode {
    public final STNode errorKeyword;
    public final STNode typeReference;
    public final STNode openParenthesis;
    public final STNode argListBindingPatterns;
    public final STNode closeParenthesis;

    STErrorBindingPatternNode(STNode errorKeyword, STNode typeReference, STNode openParenthesis, STNode argListBindingPatterns, STNode closeParenthesis) {
        this(errorKeyword, typeReference, openParenthesis, argListBindingPatterns, closeParenthesis, Collections.emptyList());
    }

    STErrorBindingPatternNode(STNode errorKeyword, STNode typeReference, STNode openParenthesis, STNode argListBindingPatterns, STNode closeParenthesis, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.ERROR_BINDING_PATTERN, diagnostics);
        this.errorKeyword = errorKeyword;
        this.typeReference = typeReference;
        this.openParenthesis = openParenthesis;
        this.argListBindingPatterns = argListBindingPatterns;
        this.closeParenthesis = closeParenthesis;
        this.addChildren(errorKeyword, typeReference, openParenthesis, argListBindingPatterns, closeParenthesis);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STErrorBindingPatternNode(this.errorKeyword, this.typeReference, this.openParenthesis, this.argListBindingPatterns, this.closeParenthesis, diagnostics);
    }

    public STErrorBindingPatternNode modify(STNode errorKeyword, STNode typeReference, STNode openParenthesis, STNode argListBindingPatterns, STNode closeParenthesis) {
        if (this.checkForReferenceEquality(errorKeyword, typeReference, openParenthesis, argListBindingPatterns, closeParenthesis)) {
            return this;
        }
        return new STErrorBindingPatternNode(errorKeyword, typeReference, openParenthesis, argListBindingPatterns, closeParenthesis, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ErrorBindingPatternNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

