/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.ErrorMatchPatternNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STErrorMatchPatternNode
extends STNode {
    public final STNode errorKeyword;
    public final STNode typeReference;
    public final STNode openParenthesisToken;
    public final STNode argListMatchPatternNode;
    public final STNode closeParenthesisToken;

    STErrorMatchPatternNode(STNode errorKeyword, STNode typeReference, STNode openParenthesisToken, STNode argListMatchPatternNode, STNode closeParenthesisToken) {
        this(errorKeyword, typeReference, openParenthesisToken, argListMatchPatternNode, closeParenthesisToken, Collections.emptyList());
    }

    STErrorMatchPatternNode(STNode errorKeyword, STNode typeReference, STNode openParenthesisToken, STNode argListMatchPatternNode, STNode closeParenthesisToken, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.ERROR_MATCH_PATTERN, diagnostics);
        this.errorKeyword = errorKeyword;
        this.typeReference = typeReference;
        this.openParenthesisToken = openParenthesisToken;
        this.argListMatchPatternNode = argListMatchPatternNode;
        this.closeParenthesisToken = closeParenthesisToken;
        this.addChildren(errorKeyword, typeReference, openParenthesisToken, argListMatchPatternNode, closeParenthesisToken);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STErrorMatchPatternNode(this.errorKeyword, this.typeReference, this.openParenthesisToken, this.argListMatchPatternNode, this.closeParenthesisToken, diagnostics);
    }

    public STErrorMatchPatternNode modify(STNode errorKeyword, STNode typeReference, STNode openParenthesisToken, STNode argListMatchPatternNode, STNode closeParenthesisToken) {
        if (this.checkForReferenceEquality(errorKeyword, typeReference, openParenthesisToken, argListMatchPatternNode, closeParenthesisToken)) {
            return this;
        }
        return new STErrorMatchPatternNode(errorKeyword, typeReference, openParenthesisToken, argListMatchPatternNode, closeParenthesisToken, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ErrorMatchPatternNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

