/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.ImportPrefixNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STImportPrefixNode
extends STNode {
    public final STNode asKeyword;
    public final STNode prefix;

    STImportPrefixNode(STNode asKeyword, STNode prefix) {
        this(asKeyword, prefix, Collections.emptyList());
    }

    STImportPrefixNode(STNode asKeyword, STNode prefix, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.IMPORT_PREFIX, diagnostics);
        this.asKeyword = asKeyword;
        this.prefix = prefix;
        this.addChildren(asKeyword, prefix);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STImportPrefixNode(this.asKeyword, this.prefix, diagnostics);
    }

    public STImportPrefixNode modify(STNode asKeyword, STNode prefix) {
        if (this.checkForReferenceEquality(asKeyword, prefix)) {
            return this;
        }
        return new STImportPrefixNode(asKeyword, prefix, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ImportPrefixNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

