/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.internal.parser.tree.STParameterNode;
import io.ballerina.compiler.syntax.tree.IncludedRecordParameterNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STIncludedRecordParameterNode
extends STParameterNode {
    public final STNode annotations;
    public final STNode asteriskToken;
    public final STNode typeName;
    public final STNode paramName;

    STIncludedRecordParameterNode(STNode annotations, STNode asteriskToken, STNode typeName, STNode paramName) {
        this(annotations, asteriskToken, typeName, paramName, Collections.emptyList());
    }

    STIncludedRecordParameterNode(STNode annotations, STNode asteriskToken, STNode typeName, STNode paramName, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.INCLUDED_RECORD_PARAM, diagnostics);
        this.annotations = annotations;
        this.asteriskToken = asteriskToken;
        this.typeName = typeName;
        this.paramName = paramName;
        this.addChildren(annotations, asteriskToken, typeName, paramName);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STIncludedRecordParameterNode(this.annotations, this.asteriskToken, this.typeName, this.paramName, diagnostics);
    }

    public STIncludedRecordParameterNode modify(STNode annotations, STNode asteriskToken, STNode typeName, STNode paramName) {
        if (this.checkForReferenceEquality(annotations, asteriskToken, typeName, paramName)) {
            return this;
        }
        return new STIncludedRecordParameterNode(annotations, asteriskToken, typeName, paramName, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new IncludedRecordParameterNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

