/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STDocumentationNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.MarkdownCodeLineNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STMarkdownCodeLineNode
extends STDocumentationNode {
    public final STNode hashToken;
    public final STNode codeDescription;

    STMarkdownCodeLineNode(STNode hashToken, STNode codeDescription) {
        this(hashToken, codeDescription, Collections.emptyList());
    }

    STMarkdownCodeLineNode(STNode hashToken, STNode codeDescription, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.MARKDOWN_CODE_LINE, diagnostics);
        this.hashToken = hashToken;
        this.codeDescription = codeDescription;
        this.addChildren(hashToken, codeDescription);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STMarkdownCodeLineNode(this.hashToken, this.codeDescription, diagnostics);
    }

    public STMarkdownCodeLineNode modify(STNode hashToken, STNode codeDescription) {
        if (this.checkForReferenceEquality(hashToken, codeDescription)) {
            return this;
        }
        return new STMarkdownCodeLineNode(hashToken, codeDescription, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new MarkdownCodeLineNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

