/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNameReferenceNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STQualifiedNameReferenceNode
extends STNameReferenceNode {
    public final STNode modulePrefix;
    public final STNode colon;
    public final STNode identifier;

    STQualifiedNameReferenceNode(STNode modulePrefix, STNode colon, STNode identifier) {
        this(modulePrefix, colon, identifier, Collections.emptyList());
    }

    STQualifiedNameReferenceNode(STNode modulePrefix, STNode colon, STNode identifier, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.QUALIFIED_NAME_REFERENCE, diagnostics);
        this.modulePrefix = modulePrefix;
        this.colon = colon;
        this.identifier = identifier;
        this.addChildren(modulePrefix, colon, identifier);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STQualifiedNameReferenceNode(this.modulePrefix, this.colon, this.identifier, diagnostics);
    }

    public STQualifiedNameReferenceNode modify(STNode modulePrefix, STNode colon, STNode identifier) {
        if (this.checkForReferenceEquality(modulePrefix, colon, identifier)) {
            return this;
        }
        return new STQualifiedNameReferenceNode(modulePrefix, colon, identifier, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new QualifiedNameReferenceNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

