/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ReFlagExpressionNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STReFlagExpressionNode
extends STNode {
    public final STNode questionMark;
    public final STNode reFlagsOnOff;
    public final STNode colon;

    STReFlagExpressionNode(STNode questionMark, STNode reFlagsOnOff, STNode colon) {
        this(questionMark, reFlagsOnOff, colon, Collections.emptyList());
    }

    STReFlagExpressionNode(STNode questionMark, STNode reFlagsOnOff, STNode colon, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.RE_FLAG_EXPR, diagnostics);
        this.questionMark = questionMark;
        this.reFlagsOnOff = reFlagsOnOff;
        this.colon = colon;
        this.addChildren(questionMark, reFlagsOnOff, colon);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STReFlagExpressionNode(this.questionMark, this.reFlagsOnOff, this.colon, diagnostics);
    }

    public STReFlagExpressionNode modify(STNode questionMark, STNode reFlagsOnOff, STNode colon) {
        if (this.checkForReferenceEquality(questionMark, reFlagsOnOff, colon)) {
            return this;
        }
        return new STReFlagExpressionNode(questionMark, reFlagsOnOff, colon, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ReFlagExpressionNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

