/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ReFlagsOnOffNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STReFlagsOnOffNode
extends STNode {
    public final STNode lhsReFlags;
    public final STNode minusToken;
    public final STNode rhsReFlags;

    STReFlagsOnOffNode(STNode lhsReFlags, STNode minusToken, STNode rhsReFlags) {
        this(lhsReFlags, minusToken, rhsReFlags, Collections.emptyList());
    }

    STReFlagsOnOffNode(STNode lhsReFlags, STNode minusToken, STNode rhsReFlags, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.RE_FLAGS_ON_OFF, diagnostics);
        this.lhsReFlags = lhsReFlags;
        this.minusToken = minusToken;
        this.rhsReFlags = rhsReFlags;
        this.addChildren(lhsReFlags, minusToken, rhsReFlags);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STReFlagsOnOffNode(this.lhsReFlags, this.minusToken, this.rhsReFlags, diagnostics);
    }

    public STReFlagsOnOffNode modify(STNode lhsReFlags, STNode minusToken, STNode rhsReFlags) {
        if (this.checkForReferenceEquality(lhsReFlags, minusToken, rhsReFlags)) {
            return this;
        }
        return new STReFlagsOnOffNode(lhsReFlags, minusToken, rhsReFlags, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new ReFlagsOnOffNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

