/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.internal.parser.tree;

import io.ballerina.compiler.internal.parser.tree.STBindingPatternNode;
import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.internal.parser.tree.STNodeDiagnostic;
import io.ballerina.compiler.internal.parser.tree.STNodeTransformer;
import io.ballerina.compiler.internal.parser.tree.STNodeVisitor;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.RestBindingPatternNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import java.util.Collection;
import java.util.Collections;

public class STRestBindingPatternNode
extends STBindingPatternNode {
    public final STNode ellipsisToken;
    public final STNode variableName;

    STRestBindingPatternNode(STNode ellipsisToken, STNode variableName) {
        this(ellipsisToken, variableName, Collections.emptyList());
    }

    STRestBindingPatternNode(STNode ellipsisToken, STNode variableName, Collection<STNodeDiagnostic> diagnostics) {
        super(SyntaxKind.REST_BINDING_PATTERN, diagnostics);
        this.ellipsisToken = ellipsisToken;
        this.variableName = variableName;
        this.addChildren(ellipsisToken, variableName);
    }

    @Override
    public STNode modifyWith(Collection<STNodeDiagnostic> diagnostics) {
        return new STRestBindingPatternNode(this.ellipsisToken, this.variableName, diagnostics);
    }

    public STRestBindingPatternNode modify(STNode ellipsisToken, STNode variableName) {
        if (this.checkForReferenceEquality(ellipsisToken, variableName)) {
            return this;
        }
        return new STRestBindingPatternNode(ellipsisToken, variableName, this.diagnostics);
    }

    @Override
    public Node createFacade(int position, NonTerminalNode parent) {
        return new RestBindingPatternNode(this, position, parent);
    }

    @Override
    public void accept(STNodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(STNodeTransformer<T> transformer) {
        return transformer.transform(this);
    }
}

