/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ActionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class AsyncSendActionNode
extends ActionNode {
    public AsyncSendActionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public ExpressionNode expression() {
        return (ExpressionNode)this.childInBucket(0);
    }

    public Token rightArrowToken() {
        return (Token)this.childInBucket(1);
    }

    public SimpleNameReferenceNode peerWorker() {
        return (SimpleNameReferenceNode)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"expression", "rightArrowToken", "peerWorker"};
    }

    public AsyncSendActionNode modify(ExpressionNode expression, Token rightArrowToken, SimpleNameReferenceNode peerWorker) {
        if (this.checkForReferenceEquality(expression, rightArrowToken, peerWorker)) {
            return this;
        }
        return NodeFactory.createAsyncSendActionNode(expression, rightArrowToken, peerWorker);
    }

    public AsyncSendActionNodeModifier modify() {
        return new AsyncSendActionNodeModifier(this);
    }

    public static class AsyncSendActionNodeModifier {
        private final AsyncSendActionNode oldNode;
        private ExpressionNode expression;
        private Token rightArrowToken;
        private SimpleNameReferenceNode peerWorker;

        public AsyncSendActionNodeModifier(AsyncSendActionNode oldNode) {
            this.oldNode = oldNode;
            this.expression = oldNode.expression();
            this.rightArrowToken = oldNode.rightArrowToken();
            this.peerWorker = oldNode.peerWorker();
        }

        public AsyncSendActionNodeModifier withExpression(ExpressionNode expression) {
            Objects.requireNonNull(expression, "expression must not be null");
            this.expression = expression;
            return this;
        }

        public AsyncSendActionNodeModifier withRightArrowToken(Token rightArrowToken) {
            Objects.requireNonNull(rightArrowToken, "rightArrowToken must not be null");
            this.rightArrowToken = rightArrowToken;
            return this;
        }

        public AsyncSendActionNodeModifier withPeerWorker(SimpleNameReferenceNode peerWorker) {
            Objects.requireNonNull(peerWorker, "peerWorker must not be null");
            this.peerWorker = peerWorker;
            return this;
        }

        public AsyncSendActionNode apply() {
            return this.oldNode.modify(this.expression, this.rightArrowToken, this.peerWorker);
        }
    }
}

