/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;
import java.util.Optional;

public class ByteArrayLiteralNode
extends ExpressionNode {
    public ByteArrayLiteralNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token type() {
        return (Token)this.childInBucket(0);
    }

    public Token startBacktick() {
        return (Token)this.childInBucket(1);
    }

    public Optional<Token> content() {
        return this.optionalChildInBucket(2);
    }

    public Token endBacktick() {
        return (Token)this.childInBucket(3);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"type", "startBacktick", "content", "endBacktick"};
    }

    public ByteArrayLiteralNode modify(Token type, Token startBacktick, Token content, Token endBacktick) {
        if (this.checkForReferenceEquality(type, startBacktick, content, endBacktick)) {
            return this;
        }
        return NodeFactory.createByteArrayLiteralNode(type, startBacktick, content, endBacktick);
    }

    public ByteArrayLiteralNodeModifier modify() {
        return new ByteArrayLiteralNodeModifier(this);
    }

    public static class ByteArrayLiteralNodeModifier {
        private final ByteArrayLiteralNode oldNode;
        private Token type;
        private Token startBacktick;
        private Token content;
        private Token endBacktick;

        public ByteArrayLiteralNodeModifier(ByteArrayLiteralNode oldNode) {
            this.oldNode = oldNode;
            this.type = oldNode.type();
            this.startBacktick = oldNode.startBacktick();
            this.content = oldNode.content().orElse(null);
            this.endBacktick = oldNode.endBacktick();
        }

        public ByteArrayLiteralNodeModifier withType(Token type) {
            Objects.requireNonNull(type, "type must not be null");
            this.type = type;
            return this;
        }

        public ByteArrayLiteralNodeModifier withStartBacktick(Token startBacktick) {
            Objects.requireNonNull(startBacktick, "startBacktick must not be null");
            this.startBacktick = startBacktick;
            return this;
        }

        public ByteArrayLiteralNodeModifier withContent(Token content) {
            this.content = content;
            return this;
        }

        public ByteArrayLiteralNodeModifier withEndBacktick(Token endBacktick) {
            Objects.requireNonNull(endBacktick, "endBacktick must not be null");
            this.endBacktick = endBacktick;
            return this;
        }

        public ByteArrayLiteralNode apply() {
            return this.oldNode.modify(this.type, this.startBacktick, this.content, this.endBacktick);
        }
    }
}

