/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class ConditionalExpressionNode
extends ExpressionNode {
    public ConditionalExpressionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public ExpressionNode lhsExpression() {
        return (ExpressionNode)this.childInBucket(0);
    }

    public Token questionMarkToken() {
        return (Token)this.childInBucket(1);
    }

    public ExpressionNode middleExpression() {
        return (ExpressionNode)this.childInBucket(2);
    }

    public Token colonToken() {
        return (Token)this.childInBucket(3);
    }

    public ExpressionNode endExpression() {
        return (ExpressionNode)this.childInBucket(4);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"lhsExpression", "questionMarkToken", "middleExpression", "colonToken", "endExpression"};
    }

    public ConditionalExpressionNode modify(ExpressionNode lhsExpression, Token questionMarkToken, ExpressionNode middleExpression, Token colonToken, ExpressionNode endExpression) {
        if (this.checkForReferenceEquality(lhsExpression, questionMarkToken, middleExpression, colonToken, endExpression)) {
            return this;
        }
        return NodeFactory.createConditionalExpressionNode(lhsExpression, questionMarkToken, middleExpression, colonToken, endExpression);
    }

    public ConditionalExpressionNodeModifier modify() {
        return new ConditionalExpressionNodeModifier(this);
    }

    public static class ConditionalExpressionNodeModifier {
        private final ConditionalExpressionNode oldNode;
        private ExpressionNode lhsExpression;
        private Token questionMarkToken;
        private ExpressionNode middleExpression;
        private Token colonToken;
        private ExpressionNode endExpression;

        public ConditionalExpressionNodeModifier(ConditionalExpressionNode oldNode) {
            this.oldNode = oldNode;
            this.lhsExpression = oldNode.lhsExpression();
            this.questionMarkToken = oldNode.questionMarkToken();
            this.middleExpression = oldNode.middleExpression();
            this.colonToken = oldNode.colonToken();
            this.endExpression = oldNode.endExpression();
        }

        public ConditionalExpressionNodeModifier withLhsExpression(ExpressionNode lhsExpression) {
            Objects.requireNonNull(lhsExpression, "lhsExpression must not be null");
            this.lhsExpression = lhsExpression;
            return this;
        }

        public ConditionalExpressionNodeModifier withQuestionMarkToken(Token questionMarkToken) {
            Objects.requireNonNull(questionMarkToken, "questionMarkToken must not be null");
            this.questionMarkToken = questionMarkToken;
            return this;
        }

        public ConditionalExpressionNodeModifier withMiddleExpression(ExpressionNode middleExpression) {
            Objects.requireNonNull(middleExpression, "middleExpression must not be null");
            this.middleExpression = middleExpression;
            return this;
        }

        public ConditionalExpressionNodeModifier withColonToken(Token colonToken) {
            Objects.requireNonNull(colonToken, "colonToken must not be null");
            this.colonToken = colonToken;
            return this;
        }

        public ConditionalExpressionNodeModifier withEndExpression(ExpressionNode endExpression) {
            Objects.requireNonNull(endExpression, "endExpression must not be null");
            this.endExpression = endExpression;
            return this;
        }

        public ConditionalExpressionNode apply() {
            return this.oldNode.modify(this.lhsExpression, this.questionMarkToken, this.middleExpression, this.colonToken, this.endExpression);
        }
    }
}

