/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class KeyTypeConstraintNode
extends NonTerminalNode {
    public KeyTypeConstraintNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token keyKeywordToken() {
        return (Token)this.childInBucket(0);
    }

    public Node typeParameterNode() {
        return this.childInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"keyKeywordToken", "typeParameterNode"};
    }

    public KeyTypeConstraintNode modify(Token keyKeywordToken, Node typeParameterNode) {
        if (this.checkForReferenceEquality(keyKeywordToken, typeParameterNode)) {
            return this;
        }
        return NodeFactory.createKeyTypeConstraintNode(keyKeywordToken, typeParameterNode);
    }

    public KeyTypeConstraintNodeModifier modify() {
        return new KeyTypeConstraintNodeModifier(this);
    }

    public static class KeyTypeConstraintNodeModifier {
        private final KeyTypeConstraintNode oldNode;
        private Token keyKeywordToken;
        private Node typeParameterNode;

        public KeyTypeConstraintNodeModifier(KeyTypeConstraintNode oldNode) {
            this.oldNode = oldNode;
            this.keyKeywordToken = oldNode.keyKeywordToken();
            this.typeParameterNode = oldNode.typeParameterNode();
        }

        public KeyTypeConstraintNodeModifier withKeyKeywordToken(Token keyKeywordToken) {
            Objects.requireNonNull(keyKeywordToken, "keyKeywordToken must not be null");
            this.keyKeywordToken = keyKeywordToken;
            return this;
        }

        public KeyTypeConstraintNodeModifier withTypeParameterNode(Node typeParameterNode) {
            Objects.requireNonNull(typeParameterNode, "typeParameterNode must not be null");
            this.typeParameterNode = typeParameterNode;
            return this;
        }

        public KeyTypeConstraintNode apply() {
            return this.oldNode.modify(this.keyKeywordToken, this.typeParameterNode);
        }
    }
}

