/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class ListConstructorExpressionNode
extends ExpressionNode {
    public ListConstructorExpressionNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token openBracket() {
        return (Token)this.childInBucket(0);
    }

    public SeparatedNodeList<Node> expressions() {
        return new SeparatedNodeList<Node>((NonTerminalNode)this.childInBucket(1));
    }

    public Token closeBracket() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"openBracket", "expressions", "closeBracket"};
    }

    public ListConstructorExpressionNode modify(Token openBracket, SeparatedNodeList<Node> expressions, Token closeBracket) {
        if (this.checkForReferenceEquality(openBracket, expressions.underlyingListNode(), closeBracket)) {
            return this;
        }
        return NodeFactory.createListConstructorExpressionNode(openBracket, expressions, closeBracket);
    }

    public ListConstructorExpressionNodeModifier modify() {
        return new ListConstructorExpressionNodeModifier(this);
    }

    public static class ListConstructorExpressionNodeModifier {
        private final ListConstructorExpressionNode oldNode;
        private Token openBracket;
        private SeparatedNodeList<Node> expressions;
        private Token closeBracket;

        public ListConstructorExpressionNodeModifier(ListConstructorExpressionNode oldNode) {
            this.oldNode = oldNode;
            this.openBracket = oldNode.openBracket();
            this.expressions = oldNode.expressions();
            this.closeBracket = oldNode.closeBracket();
        }

        public ListConstructorExpressionNodeModifier withOpenBracket(Token openBracket) {
            Objects.requireNonNull(openBracket, "openBracket must not be null");
            this.openBracket = openBracket;
            return this;
        }

        public ListConstructorExpressionNodeModifier withExpressions(SeparatedNodeList<Node> expressions) {
            Objects.requireNonNull(expressions, "expressions must not be null");
            this.expressions = expressions;
            return this;
        }

        public ListConstructorExpressionNodeModifier withCloseBracket(Token closeBracket) {
            Objects.requireNonNull(closeBracket, "closeBracket must not be null");
            this.closeBracket = closeBracket;
            return this;
        }

        public ListConstructorExpressionNode apply() {
            return this.oldNode.modify(this.openBracket, this.expressions, this.closeBracket);
        }
    }
}

