/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypeParameterNode;
import java.util.Objects;

public class MapTypeDescriptorNode
extends TypeDescriptorNode {
    public MapTypeDescriptorNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token mapKeywordToken() {
        return (Token)this.childInBucket(0);
    }

    public TypeParameterNode mapTypeParamsNode() {
        return (TypeParameterNode)this.childInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"mapKeywordToken", "mapTypeParamsNode"};
    }

    public MapTypeDescriptorNode modify(Token mapKeywordToken, TypeParameterNode mapTypeParamsNode) {
        if (this.checkForReferenceEquality(mapKeywordToken, mapTypeParamsNode)) {
            return this;
        }
        return NodeFactory.createMapTypeDescriptorNode(mapKeywordToken, mapTypeParamsNode);
    }

    public MapTypeDescriptorNodeModifier modify() {
        return new MapTypeDescriptorNodeModifier(this);
    }

    public static class MapTypeDescriptorNodeModifier {
        private final MapTypeDescriptorNode oldNode;
        private Token mapKeywordToken;
        private TypeParameterNode mapTypeParamsNode;

        public MapTypeDescriptorNodeModifier(MapTypeDescriptorNode oldNode) {
            this.oldNode = oldNode;
            this.mapKeywordToken = oldNode.mapKeywordToken();
            this.mapTypeParamsNode = oldNode.mapTypeParamsNode();
        }

        public MapTypeDescriptorNodeModifier withMapKeywordToken(Token mapKeywordToken) {
            Objects.requireNonNull(mapKeywordToken, "mapKeywordToken must not be null");
            this.mapKeywordToken = mapKeywordToken;
            return this;
        }

        public MapTypeDescriptorNodeModifier withMapTypeParamsNode(TypeParameterNode mapTypeParamsNode) {
            Objects.requireNonNull(mapTypeParamsNode, "mapTypeParamsNode must not be null");
            this.mapTypeParamsNode = mapTypeParamsNode;
            return this;
        }

        public MapTypeDescriptorNode apply() {
            return this.oldNode.modify(this.mapKeywordToken, this.mapTypeParamsNode);
        }
    }
}

