/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class MappingMatchPatternNode
extends NonTerminalNode {
    public MappingMatchPatternNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token openBraceToken() {
        return (Token)this.childInBucket(0);
    }

    public SeparatedNodeList<Node> fieldMatchPatterns() {
        return new SeparatedNodeList<Node>((NonTerminalNode)this.childInBucket(1));
    }

    public Token closeBraceToken() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"openBraceToken", "fieldMatchPatterns", "closeBraceToken"};
    }

    public MappingMatchPatternNode modify(Token openBraceToken, SeparatedNodeList<Node> fieldMatchPatterns, Token closeBraceToken) {
        if (this.checkForReferenceEquality(openBraceToken, fieldMatchPatterns.underlyingListNode(), closeBraceToken)) {
            return this;
        }
        return NodeFactory.createMappingMatchPatternNode(openBraceToken, fieldMatchPatterns, closeBraceToken);
    }

    public MappingMatchPatternNodeModifier modify() {
        return new MappingMatchPatternNodeModifier(this);
    }

    public static class MappingMatchPatternNodeModifier {
        private final MappingMatchPatternNode oldNode;
        private Token openBraceToken;
        private SeparatedNodeList<Node> fieldMatchPatterns;
        private Token closeBraceToken;

        public MappingMatchPatternNodeModifier(MappingMatchPatternNode oldNode) {
            this.oldNode = oldNode;
            this.openBraceToken = oldNode.openBraceToken();
            this.fieldMatchPatterns = oldNode.fieldMatchPatterns();
            this.closeBraceToken = oldNode.closeBraceToken();
        }

        public MappingMatchPatternNodeModifier withOpenBraceToken(Token openBraceToken) {
            Objects.requireNonNull(openBraceToken, "openBraceToken must not be null");
            this.openBraceToken = openBraceToken;
            return this;
        }

        public MappingMatchPatternNodeModifier withFieldMatchPatterns(SeparatedNodeList<Node> fieldMatchPatterns) {
            Objects.requireNonNull(fieldMatchPatterns, "fieldMatchPatterns must not be null");
            this.fieldMatchPatterns = fieldMatchPatterns;
            return this;
        }

        public MappingMatchPatternNodeModifier withCloseBraceToken(Token closeBraceToken) {
            Objects.requireNonNull(closeBraceToken, "closeBraceToken must not be null");
            this.closeBraceToken = closeBraceToken;
            return this;
        }

        public MappingMatchPatternNode apply() {
            return this.oldNode.modify(this.openBraceToken, this.fieldMatchPatterns, this.closeBraceToken);
        }
    }
}

