/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class ModulePartNode
extends NonTerminalNode {
    public ModulePartNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public NodeList<ImportDeclarationNode> imports() {
        return new NodeList<ImportDeclarationNode>((NonTerminalNode)this.childInBucket(0));
    }

    public NodeList<ModuleMemberDeclarationNode> members() {
        return new NodeList<ModuleMemberDeclarationNode>((NonTerminalNode)this.childInBucket(1));
    }

    public Token eofToken() {
        return (Token)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"imports", "members", "eofToken"};
    }

    public ModulePartNode modify(NodeList<ImportDeclarationNode> imports, NodeList<ModuleMemberDeclarationNode> members, Token eofToken) {
        if (this.checkForReferenceEquality(imports.underlyingListNode(), members.underlyingListNode(), eofToken)) {
            return this;
        }
        return NodeFactory.createModulePartNode(imports, members, eofToken);
    }

    public ModulePartNodeModifier modify() {
        return new ModulePartNodeModifier(this);
    }

    public static class ModulePartNodeModifier {
        private final ModulePartNode oldNode;
        private NodeList<ImportDeclarationNode> imports;
        private NodeList<ModuleMemberDeclarationNode> members;
        private Token eofToken;

        public ModulePartNodeModifier(ModulePartNode oldNode) {
            this.oldNode = oldNode;
            this.imports = oldNode.imports();
            this.members = oldNode.members();
            this.eofToken = oldNode.eofToken();
        }

        public ModulePartNodeModifier withImports(NodeList<ImportDeclarationNode> imports) {
            Objects.requireNonNull(imports, "imports must not be null");
            this.imports = imports;
            return this;
        }

        public ModulePartNodeModifier withMembers(NodeList<ModuleMemberDeclarationNode> members) {
            Objects.requireNonNull(members, "members must not be null");
            this.members = members;
            return this;
        }

        public ModulePartNodeModifier withEofToken(Token eofToken) {
            Objects.requireNonNull(eofToken, "eofToken must not be null");
            this.eofToken = eofToken;
            return this;
        }

        public ModulePartNode apply() {
            return this.oldNode.modify(this.imports, this.members, this.eofToken);
        }
    }
}

