/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class SpreadFieldNode
extends MappingFieldNode {
    public SpreadFieldNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token ellipsis() {
        return (Token)this.childInBucket(0);
    }

    public ExpressionNode valueExpr() {
        return (ExpressionNode)this.childInBucket(1);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"ellipsis", "valueExpr"};
    }

    public SpreadFieldNode modify(Token ellipsis, ExpressionNode valueExpr) {
        if (this.checkForReferenceEquality(ellipsis, valueExpr)) {
            return this;
        }
        return NodeFactory.createSpreadFieldNode(ellipsis, valueExpr);
    }

    public SpreadFieldNodeModifier modify() {
        return new SpreadFieldNodeModifier(this);
    }

    public static class SpreadFieldNodeModifier {
        private final SpreadFieldNode oldNode;
        private Token ellipsis;
        private ExpressionNode valueExpr;

        public SpreadFieldNodeModifier(SpreadFieldNode oldNode) {
            this.oldNode = oldNode;
            this.ellipsis = oldNode.ellipsis();
            this.valueExpr = oldNode.valueExpr();
        }

        public SpreadFieldNodeModifier withEllipsis(Token ellipsis) {
            Objects.requireNonNull(ellipsis, "ellipsis must not be null");
            this.ellipsis = ellipsis;
            return this;
        }

        public SpreadFieldNodeModifier withValueExpr(ExpressionNode valueExpr) {
            Objects.requireNonNull(valueExpr, "valueExpr must not be null");
            this.valueExpr = valueExpr;
            return this;
        }

        public SpreadFieldNode apply() {
            return this.oldNode.modify(this.ellipsis, this.valueExpr);
        }
    }
}

