/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.compiler.syntax.tree;

import io.ballerina.compiler.internal.parser.tree.STNode;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeTransformer;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.NonTerminalNode;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.Token;
import java.util.Objects;

public class XMLStepMethodCallExtendNode
extends NonTerminalNode {
    public XMLStepMethodCallExtendNode(STNode internalNode, int position, NonTerminalNode parent) {
        super(internalNode, position, parent);
    }

    public Token dotToken() {
        return (Token)this.childInBucket(0);
    }

    public SimpleNameReferenceNode methodName() {
        return (SimpleNameReferenceNode)this.childInBucket(1);
    }

    public ParenthesizedArgList parenthesizedArgList() {
        return (ParenthesizedArgList)this.childInBucket(2);
    }

    @Override
    public void accept(NodeVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public <T> T apply(NodeTransformer<T> visitor) {
        return visitor.transform(this);
    }

    @Override
    protected String[] childNames() {
        return new String[]{"dotToken", "methodName", "parenthesizedArgList"};
    }

    public XMLStepMethodCallExtendNode modify(Token dotToken, SimpleNameReferenceNode methodName, ParenthesizedArgList parenthesizedArgList) {
        if (this.checkForReferenceEquality(dotToken, methodName, parenthesizedArgList)) {
            return this;
        }
        return NodeFactory.createXMLStepMethodCallExtendNode(dotToken, methodName, parenthesizedArgList);
    }

    public XMLStepMethodCallExtendNodeModifier modify() {
        return new XMLStepMethodCallExtendNodeModifier(this);
    }

    public static class XMLStepMethodCallExtendNodeModifier {
        private final XMLStepMethodCallExtendNode oldNode;
        private Token dotToken;
        private SimpleNameReferenceNode methodName;
        private ParenthesizedArgList parenthesizedArgList;

        public XMLStepMethodCallExtendNodeModifier(XMLStepMethodCallExtendNode oldNode) {
            this.oldNode = oldNode;
            this.dotToken = oldNode.dotToken();
            this.methodName = oldNode.methodName();
            this.parenthesizedArgList = oldNode.parenthesizedArgList();
        }

        public XMLStepMethodCallExtendNodeModifier withDotToken(Token dotToken) {
            Objects.requireNonNull(dotToken, "dotToken must not be null");
            this.dotToken = dotToken;
            return this;
        }

        public XMLStepMethodCallExtendNodeModifier withMethodName(SimpleNameReferenceNode methodName) {
            Objects.requireNonNull(methodName, "methodName must not be null");
            this.methodName = methodName;
            return this;
        }

        public XMLStepMethodCallExtendNodeModifier withParenthesizedArgList(ParenthesizedArgList parenthesizedArgList) {
            Objects.requireNonNull(parenthesizedArgList, "parenthesizedArgList must not be null");
            this.parenthesizedArgList = parenthesizedArgList;
            return this;
        }

        public XMLStepMethodCallExtendNode apply() {
            return this.oldNode.modify(this.dotToken, this.methodName, this.parenthesizedArgList);
        }
    }
}

