/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.validator;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.ConstantSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.ServiceDeclarationSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.SymbolKind;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.UnionTypeSymbol;
import io.ballerina.compiler.syntax.tree.AnnotationNode;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.DefaultableParameterNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.ListConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingFieldNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ParameterNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.RequiredParameterNode;
import io.ballerina.compiler.syntax.tree.ResourcePathParameterNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.openapi.validator.ValidatorContext;
import io.ballerina.openapi.validator.error.CompilationError;
import io.ballerina.openapi.validator.model.Filter;
import io.ballerina.openapi.validator.model.OpenAPIPathSummary;
import io.ballerina.openapi.validator.model.ResourceMethod;
import io.ballerina.openapi.validator.model.ResourcePathSummary;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import io.swagger.v3.oas.models.OpenAPI;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.Paths;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.parser.OpenAPIV3Parser;
import io.swagger.v3.parser.core.models.ParseOptions;
import io.swagger.v3.parser.core.models.SwaggerParseResult;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class ValidatorUtils {
    public static String getNormalizedPath(String path) {
        return path;
    }

    public static OpenAPI parseOpenAPIFile(SyntaxNodeAnalysisContext context, String definitionURI, Location location) throws IOException {
        Path contractPath = java.nio.file.Paths.get(definitionURI, new String[0]);
        ParseOptions parseOptions = new ParseOptions();
        if (!Files.exists(contractPath, new LinkOption[0])) {
            ValidatorUtils.reportDiagnostic(context, CompilationError.INVALID_CONTRACT_PATH, location, DiagnosticSeverity.ERROR, contractPath);
            return null;
        }
        if (!(definitionURI.endsWith(".yaml") || definitionURI.endsWith(".json") || definitionURI.endsWith(".yml"))) {
            ValidatorUtils.reportDiagnostic(context, CompilationError.INVALID_CONTRACT_FORMAT, location, DiagnosticSeverity.ERROR, new Object[0]);
            return null;
        }
        String openAPIFileContent = Files.readString(contractPath);
        SwaggerParseResult parseResult = new OpenAPIV3Parser().readContents(openAPIFileContent, null, parseOptions);
        OpenAPI api = parseResult.getOpenAPI();
        if (api == null) {
            ValidatorUtils.reportDiagnostic(context, CompilationError.PARSER_EXCEPTION, location, DiagnosticSeverity.ERROR, definitionURI);
        }
        return api;
    }

    public static boolean isHttpService(ServiceDeclarationNode serviceNode, SemanticModel semanticModel) {
        Optional serviceSymbol = semanticModel.symbol((Node)serviceNode);
        ServiceDeclarationSymbol serviceNodeSymbol = (ServiceDeclarationSymbol)serviceSymbol.get();
        List listenerTypes = serviceNodeSymbol.listenerTypes();
        for (TypeSymbol listenerType : listenerTypes) {
            if (!ValidatorUtils.isHttpListener(listenerType)) continue;
            return true;
        }
        return false;
    }

    private static boolean isHttpListener(TypeSymbol listenerType) {
        if (listenerType.typeKind() == TypeDescKind.UNION) {
            return ((UnionTypeSymbol)listenerType).memberTypeDescriptors().stream().filter(typeDescriptor -> typeDescriptor instanceof TypeReferenceTypeSymbol).map(typeReferenceTypeSymbol -> (TypeReferenceTypeSymbol)typeReferenceTypeSymbol).anyMatch(typeReferenceTypeSymbol -> ValidatorUtils.isHttpModule((ModuleSymbol)typeReferenceTypeSymbol.getModule().get()));
        }
        if (listenerType.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            return ValidatorUtils.isHttpModule((ModuleSymbol)((TypeReferenceTypeSymbol)listenerType).typeDescriptor().getModule().get());
        }
        return false;
    }

    private static boolean isHttpModule(ModuleSymbol moduleSymbol) {
        if (moduleSymbol.getName().isPresent()) {
            return "http".equals(moduleSymbol.getName().get()) && "ballerina".equals(moduleSymbol.id().orgName());
        }
        return false;
    }

    public static void reportDiagnostic(SyntaxNodeAnalysisContext context, CompilationError error, Location location, DiagnosticSeverity severity, Object ... args) {
        DiagnosticInfo diagnosticInfo = new DiagnosticInfo(error.getCode(), error.getDescription(), severity);
        Diagnostic diagnostic = DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticInfo, (Location)location, (Object[])args);
        context.reportDiagnostic(diagnostic);
    }

    public static void reportDiagnostic(ValidatorContext validatorContext, CompilationError error, Object ... args) {
        ValidatorUtils.reportDiagnostic(validatorContext.getContext(), error, validatorContext.getLocation(), validatorContext.getSeverity(), args);
    }

    private static boolean applyFilter(Filter filter, List<String> tags, String operationId, SyntaxNodeAnalysisContext context) {
        boolean excludeOperationEnable;
        boolean tagEnabled = filter.getTag() != null;
        boolean operationEnabled = filter.getOperation() != null;
        boolean excludeTagsEnabled = filter.getExcludeTag() != null;
        boolean bl = excludeOperationEnable = filter.getExcludeOperation() != null;
        if (excludeTagsEnabled && excludeOperationEnable) {
            return tags == null || Collections.disjoint(tags, filter.getExcludeTag()) && operationId != null && !filter.getExcludeOperation().contains(operationId);
        }
        if (tagEnabled && operationEnabled) {
            return operationId != null && filter.getOperation().contains(operationId) || tags != null && !Collections.disjoint(tags, filter.getTag());
        }
        if (operationEnabled) {
            if (excludeTagsEnabled) {
                return tags == null || Collections.disjoint(tags, filter.getExcludeTag());
            }
            return operationId != null && filter.getOperation().contains(operationId);
        }
        if (tagEnabled) {
            if (tags != null && !Collections.disjoint(tags, filter.getTag()) && excludeOperationEnable) {
                return operationId != null && !filter.getExcludeOperation().contains(operationId);
            }
            return tags != null && !Collections.disjoint(tags, filter.getTag());
        }
        if (excludeOperationEnable) {
            return operationId != null && !filter.getExcludeOperation().contains(operationId);
        }
        if (excludeTagsEnabled) {
            return tags == null || filter.getExcludeTag() != null && Collections.disjoint(tags, filter.getExcludeTag());
        }
        return true;
    }

    public static List<OpenAPIPathSummary> summarizeOpenAPI(OpenAPI contract, SyntaxNodeAnalysisContext context, Filter filter) {
        ArrayList<OpenAPIPathSummary> openAPISummaries = new ArrayList<OpenAPIPathSummary>();
        Paths paths = contract.getPaths();
        paths.forEach((path, value) -> {
            OpenAPIPathSummary openAPISummary = new OpenAPIPathSummary();
            if (value != null) {
                openAPISummary.setPath((String)path);
                if (value.getGet() != null) {
                    ValidatorUtils.addOpenAPISummary(openAPISummary, "get", value.getGet(), filter, context);
                }
                if (value.getPost() != null) {
                    ValidatorUtils.addOpenAPISummary(openAPISummary, "post", value.getPost(), filter, context);
                }
                if (value.getPut() != null) {
                    ValidatorUtils.addOpenAPISummary(openAPISummary, "put", value.getPut(), filter, context);
                }
                if (value.getDelete() != null) {
                    ValidatorUtils.addOpenAPISummary(openAPISummary, "delete", value.getDelete(), filter, context);
                }
                if (value.getHead() != null) {
                    ValidatorUtils.addOpenAPISummary(openAPISummary, "head", value.getHead(), filter, context);
                }
                if (value.getPatch() != null) {
                    ValidatorUtils.addOpenAPISummary(openAPISummary, "patch", value.getPatch(), filter, context);
                }
                if (value.getOptions() != null) {
                    ValidatorUtils.addOpenAPISummary(openAPISummary, "options", value.getOptions(), filter, context);
                }
                if (value.getTrace() != null) {
                    ValidatorUtils.addOpenAPISummary(openAPISummary, "trace", value.getTrace(), filter, context);
                }
            }
            if (openAPISummary.getOperations().size() > 0) {
                openAPISummaries.add(openAPISummary);
            }
        });
        return openAPISummaries;
    }

    private static void addOpenAPISummary(OpenAPIPathSummary openAPISummary, String httpMethod, Operation operation, Filter filter, SyntaxNodeAnalysisContext context) {
        openAPISummary.addAvailableOperation(httpMethod);
        if (ValidatorUtils.applyFilter(filter, operation.getTags(), operation.getOperationId(), context)) {
            openAPISummary.addOperation(httpMethod, operation);
        }
    }

    public static Map<String, ResourcePathSummary> summarizeResources(List<FunctionDefinitionNode> functions, SyntaxNodeAnalysisContext context) {
        HashMap<String, ResourcePathSummary> resourceSummaryList = new HashMap<String, ResourcePathSummary>();
        for (FunctionDefinitionNode resourceNode : functions) {
            HashMap<String, Node> parameterNodeMap;
            NodeList relativeResourcePathNodes = resourceNode.relativeResourcePath();
            String path = ValidatorUtils.generatePath((NodeList<Node>)relativeResourcePathNodes, parameterNodeMap = new HashMap<String, Node>());
            if (resourceSummaryList.containsKey(path)) {
                ValidatorUtils.extractResourceMethodDetails(resourceNode, path, (ResourcePathSummary)resourceSummaryList.get(path), parameterNodeMap, context);
                continue;
            }
            ResourcePathSummary resourcePathSummary = new ResourcePathSummary(path);
            ValidatorUtils.extractResourceMethodDetails(resourceNode, path, resourcePathSummary, parameterNodeMap, context);
            resourceSummaryList.put(path, resourcePathSummary);
        }
        return resourceSummaryList;
    }

    private static String generatePath(NodeList<Node> nodes, Map<String, Node> parameterNodeMap) {
        StringBuilder pathBuilder = new StringBuilder();
        pathBuilder.append("/");
        for (Node next : nodes) {
            Object node = next.toString().trim();
            if (next instanceof ResourcePathParameterNode) {
                ResourcePathParameterNode pathParameterNode = (ResourcePathParameterNode)next;
                String paramName = ValidatorUtils.unescapeIdentifier(((Token)pathParameterNode.paramName().get()).text().trim());
                node = "{" + paramName + "}";
                parameterNodeMap.put(paramName, next);
            }
            pathBuilder.append((String)node);
        }
        String path = pathBuilder.toString();
        if (!path.endsWith(".")) {
            return path;
        }
        return path.substring(0, path.length() - 1);
    }

    private static void extractResourceMethodDetails(FunctionDefinitionNode resourceNode, String path, ResourcePathSummary resourcePath, Map<String, Node> parameterNodes, SyntaxNodeAnalysisContext context) {
        FunctionSignatureNode signatureNode = resourceNode.functionSignature();
        String httpMethod = resourceNode.functionName().text().trim();
        SeparatedNodeList parameters = signatureNode.parameters();
        ResourceMethod.ResourceMethodBuilder resourceMethodBuilder = new ResourceMethod.ResourceMethodBuilder();
        resourceMethodBuilder.withPath(path);
        resourceMethodBuilder.withMethod(httpMethod);
        resourceMethodBuilder.withLocation((Location)resourceNode.location());
        HashMap<String, Node> headers = new HashMap<String, Node>();
        for (ParameterNode param : parameters) {
            NodeList annotations;
            if (param instanceof RequiredParameterNode) {
                RequiredParameterNode requiredParamNode = (RequiredParameterNode)param;
                annotations = requiredParamNode.annotations();
                if (requiredParamNode.typeName().toString().trim().equals("http:Caller") || requiredParamNode.typeName().toString().trim().equals("http:Request")) continue;
                for (AnnotationNode annotation : annotations) {
                    if (annotation.annotReference().toString().trim().equals("http:Header")) {
                        List<String> annotationHeaders = ValidatorUtils.extractAnnotationFieldDetails("http:Header", "name", (NodeList<AnnotationNode>)annotations, context.semanticModel());
                        String headerName = ValidatorUtils.unescapeIdentifier(((Token)requiredParamNode.paramName().orElseThrow()).text());
                        if (!annotationHeaders.isEmpty()) {
                            headerName = annotationHeaders.get(0);
                        }
                        headers.put(headerName, (Node)requiredParamNode);
                        continue;
                    }
                    if (!annotation.annotReference().toString().trim().equals("http:Payload")) continue;
                    resourceMethodBuilder.withBody(requiredParamNode);
                }
                if (!annotations.isEmpty()) continue;
                parameterNodes.put(((Token)requiredParamNode.paramName().orElseThrow()).text(), (Node)requiredParamNode);
                continue;
            }
            if (!(param instanceof DefaultableParameterNode)) continue;
            DefaultableParameterNode defaultParam = (DefaultableParameterNode)param;
            annotations = defaultParam.annotations();
            if (defaultParam.typeName().toString().equals("http:Caller") || defaultParam.typeName().toString().equals("http:Request")) continue;
            for (AnnotationNode annotation : annotations) {
                if (!annotation.annotReference().toString().trim().equals("http:Header")) continue;
                headers.put(((Token)defaultParam.paramName().orElseThrow()).text(), (Node)defaultParam);
            }
            if (!annotations.isEmpty()) continue;
            parameterNodes.put(((Token)defaultParam.paramName().orElseThrow()).text(), (Node)defaultParam);
        }
        resourceMethodBuilder.withHeaders(headers);
        resourceMethodBuilder.withParameters(parameterNodes);
        resourceMethodBuilder.withReturnNode(signatureNode.returnTypeDesc().orElse(null));
        resourcePath.addMethod(httpMethod, resourceMethodBuilder.build());
    }

    public static String unescapeIdentifier(String parameterName) {
        return parameterName.replaceAll("\\\\", "");
    }

    public static List<String> extractAnnotationFieldDetails(String annotationReference, String annotationField, NodeList<AnnotationNode> annotations, SemanticModel semanticModel) {
        ArrayList<String> fieldValues = new ArrayList<String>();
        Iterator iterator = annotations.stream().iterator();
        while (iterator.hasNext()) {
            AnnotationNode annotation = (AnnotationNode)iterator.next();
            Node annotReference = annotation.annotReference();
            if (!annotReference.toString().trim().equals(annotationReference) || !annotation.annotValue().isPresent()) continue;
            MappingConstructorExpressionNode listOfAnnotValue = (MappingConstructorExpressionNode)annotation.annotValue().get();
            for (MappingFieldNode field : listOfAnnotValue.fields()) {
                SpecificFieldNode fieldNode = (SpecificFieldNode)field;
                if (!fieldNode.fieldName().toString().trim().equals(annotationField) && fieldNode.valueExpr().isEmpty()) continue;
                ExpressionNode expressionNode = (ExpressionNode)fieldNode.valueExpr().get();
                if (expressionNode instanceof ListConstructorExpressionNode) {
                    SeparatedNodeList mimeList = ((ListConstructorExpressionNode)expressionNode).expressions();
                    for (Object mime : mimeList) {
                        if (!(mime instanceof BasicLiteralNode)) continue;
                        fieldValues.add(((BasicLiteralNode)mime).literalToken().text().trim().replaceAll("\"", ""));
                    }
                    continue;
                }
                if (expressionNode instanceof QualifiedNameReferenceNode && semanticModel != null) {
                    QualifiedNameReferenceNode moduleRef = (QualifiedNameReferenceNode)expressionNode;
                    Optional refSymbol = semanticModel.symbol((Node)moduleRef);
                    if (!refSymbol.isPresent() || ((Symbol)refSymbol.get()).kind() != SymbolKind.CONSTANT || !((ConstantSymbol)refSymbol.get()).resolvedValue().isPresent()) continue;
                    String mediaType = (String)((ConstantSymbol)refSymbol.get()).resolvedValue().get();
                    fieldValues.add(mediaType.replaceAll("\"", ""));
                    continue;
                }
                fieldValues.add(expressionNode.toString().trim().replaceAll("\"", ""));
            }
        }
        return fieldValues;
    }

    public static String getMediaType(SyntaxKind kind) {
        return switch (kind) {
            case SyntaxKind.STRING_TYPE_DESC -> "text/plain";
            case SyntaxKind.XML_TYPE_DESC -> "application/xml";
            default -> "application/json";
        };
    }

    public static String getMediaType(TypeDescKind kind) {
        return switch (kind) {
            case TypeDescKind.STRING -> "text/plain";
            case TypeDescKind.XML -> "application/xml";
            default -> "application/json";
        };
    }

    public static Optional<String> extractReferenceType(String referenceVariable) {
        if (referenceVariable.startsWith("#") && referenceVariable.contains("/")) {
            String[] refArray = referenceVariable.split("/");
            return Optional.of(refArray[refArray.length - 1]);
        }
        return Optional.empty();
    }

    public static String getNumberFormatType(Schema<?> schema) {
        String type = schema.getType();
        if (type != null && type.equals("number")) {
            type = "double";
            if (schema.getFormat() != null && schema.getFormat().equals("float")) {
                type = "float";
            }
        }
        return type;
    }
}

