/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.openapi.validator.example;

import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.AnnotationAttachmentSymbol;
import io.ballerina.compiler.api.symbols.TypeDefinitionSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.openapi.validator.diagnostic.OpenAPIDiagnosticCodes;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.util.List;
import java.util.Optional;

public abstract class AbstractExampleAnalyzer
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    void validateExampleAnnotationUsage(SyntaxNodeAnalysisContext context, TypeSymbol typeSymbol, List<AnnotationAttachmentSymbol> annotations, SemanticModel semanticModel) {
        Optional<AnnotationAttachmentSymbol> example = this.getOpenAPIExampleAnnotation(annotations, semanticModel);
        if (example.isEmpty() || !example.get().isConstAnnotation() || example.get().attachmentValue().isEmpty()) {
            return;
        }
        if (!typeSymbol.subtypeOf(semanticModel.types().ANYDATA)) {
            context.reportDiagnostic(OpenAPIDiagnosticCodes.OPENAPI_100.getDiagnosticCode(example.get().getLocation().orElse(null)));
        }
    }

    void invalidateExampleAnnotationUsage(SyntaxNodeAnalysisContext context, SemanticModel semanticModel, List<AnnotationAttachmentSymbol> annotations) {
        Optional<AnnotationAttachmentSymbol> example = this.getOpenAPIExampleAnnotation(annotations, semanticModel);
        example.ifPresent(annotationAttachmentSymbol -> context.reportDiagnostic(OpenAPIDiagnosticCodes.OPENAPI_104.getDiagnosticCode(annotationAttachmentSymbol.getLocation().orElse(null))));
    }

    private Optional<AnnotationAttachmentSymbol> getOpenAPIExampleAnnotation(List<AnnotationAttachmentSymbol> annotations, SemanticModel semanticModel) {
        return annotations.stream().filter(annotAttachment -> this.isOpenAPIExampleAnnotation((AnnotationAttachmentSymbol)annotAttachment, semanticModel)).findFirst();
    }

    void validateExamplesAnnotationUsage(SyntaxNodeAnalysisContext context, TypeSymbol typeSymbol, List<AnnotationAttachmentSymbol> annotations, SemanticModel semanticModel) {
        Optional<AnnotationAttachmentSymbol> examples = this.getOpenAPIExamplesAnnotation(annotations, semanticModel);
        if (examples.isEmpty() || !examples.get().isConstAnnotation() || examples.get().attachmentValue().isEmpty()) {
            return;
        }
        if (!typeSymbol.subtypeOf(semanticModel.types().ANYDATA)) {
            context.reportDiagnostic(OpenAPIDiagnosticCodes.OPENAPI_101.getDiagnosticCode(examples.get().getLocation().orElse(null)));
        }
    }

    void invalidateBothExampleAnnotations(SyntaxNodeAnalysisContext context, SemanticModel semanticModel, List<AnnotationAttachmentSymbol> annotations) {
        this.invalidateExampleAnnotationUsage(context, semanticModel, annotations);
        this.invalidateExamplesAnnotationUsage(context, semanticModel, annotations);
    }

    void invalidateExamplesAnnotationUsage(SyntaxNodeAnalysisContext context, SemanticModel semanticModel, List<AnnotationAttachmentSymbol> annotations) {
        Optional<AnnotationAttachmentSymbol> examples = this.getOpenAPIExamplesAnnotation(annotations, semanticModel);
        examples.ifPresent(annotationAttachmentSymbol -> context.reportDiagnostic(OpenAPIDiagnosticCodes.OPENAPI_105.getDiagnosticCode(annotationAttachmentSymbol.getLocation().orElse(null))));
    }

    private Optional<AnnotationAttachmentSymbol> getOpenAPIExamplesAnnotation(List<AnnotationAttachmentSymbol> annotations, SemanticModel semanticModel) {
        return annotations.stream().filter(annotAttachment -> this.isOpenAPIExamplesAnnotation((AnnotationAttachmentSymbol)annotAttachment, semanticModel)).findFirst();
    }

    void validateBothExampleAnnotations(SyntaxNodeAnalysisContext context, List<AnnotationAttachmentSymbol> annotations, SemanticModel semanticModel) {
        if (this.hasBothOpenAPIExampleAnnotations(annotations, semanticModel)) {
            Optional<AnnotationAttachmentSymbol> openAPIExamples = annotations.stream().filter(annotAttachment -> this.isOpenAPIExamplesAnnotation((AnnotationAttachmentSymbol)annotAttachment, semanticModel)).findFirst();
            context.reportDiagnostic(OpenAPIDiagnosticCodes.OPENAPI_102.getDiagnosticCode(openAPIExamples.get().getLocation().orElse(null)));
        }
    }

    boolean hasBothOpenAPIExampleAnnotations(List<AnnotationAttachmentSymbol> annotations, SemanticModel semanticModel) {
        return annotations.stream().anyMatch(annotAttachment -> this.isOpenAPIExampleAnnotation((AnnotationAttachmentSymbol)annotAttachment, semanticModel)) && annotations.stream().anyMatch(annotAttachment -> this.isOpenAPIExamplesAnnotation((AnnotationAttachmentSymbol)annotAttachment, semanticModel));
    }

    boolean diagnosticContainsErrors(SyntaxNodeAnalysisContext syntaxNodeAnalysisContext) {
        List diagnostics = syntaxNodeAnalysisContext.semanticModel().diagnostics();
        return diagnostics.stream().anyMatch(d -> DiagnosticSeverity.ERROR.equals((Object)d.diagnosticInfo().severity()));
    }

    void validateRestParameterAnnotations(SyntaxNodeAnalysisContext context, List<AnnotationAttachmentSymbol> annotations, SemanticModel semanticModel) {
        this.getOpenAPIExampleAnnotation(annotations, semanticModel).ifPresent(annotAttachment -> this.reportUnsupportedAnnotationForRestParam(context, annotAttachment.getLocation().orElse(null)));
        this.getOpenAPIExamplesAnnotation(annotations, semanticModel).ifPresent(annotAttachment -> this.reportUnsupportedAnnotationForRestParam(context, annotAttachment.getLocation().orElse(null)));
    }

    private void reportUnsupportedAnnotationForRestParam(SyntaxNodeAnalysisContext context, Location location) {
        context.reportDiagnostic(OpenAPIDiagnosticCodes.OPENAPI_103.getDiagnosticCode(location));
    }

    private boolean isOpenAPIExampleAnnotation(AnnotationAttachmentSymbol annotAttachment, SemanticModel semanticModel) {
        return this.isOpenAPIAnnotation(annotAttachment, "ExampleValue", semanticModel);
    }

    private boolean isOpenAPIExamplesAnnotation(AnnotationAttachmentSymbol annotAttachment, SemanticModel semanticModel) {
        return this.isOpenAPIAnnotation(annotAttachment, "ExampleValues", semanticModel);
    }

    private boolean isOpenAPIAnnotation(AnnotationAttachmentSymbol annotAttachment, String annotationName, SemanticModel semanticModel) {
        Object t;
        if (annotAttachment.typeDescriptor().typeDescriptor().isEmpty()) {
            return false;
        }
        Optional exampleValueSymbol = semanticModel.types().getTypeByName("ballerina", "openapi", "", annotationName);
        if (exampleValueSymbol.isEmpty() || !((t = exampleValueSymbol.get()) instanceof TypeDefinitionSymbol)) {
            return false;
        }
        TypeDefinitionSymbol serviceContractInfoType = (TypeDefinitionSymbol)t;
        return ((TypeSymbol)annotAttachment.typeDescriptor().typeDescriptor().get()).subtypeOf(serviceContractInfoType.typeDescriptor());
    }
}

