/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.architecturemodelgenerator.core.diagnostics;

import io.ballerina.architecturemodelgenerator.core.diagnostics.DiagnosticLocation;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticProperty;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;
import io.ballerina.tools.diagnostics.Location;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.List;

public class ArchitectureModelDiagnostic
extends Diagnostic {
    private final DiagnosticInfo diagnosticInfo;
    private final DiagnosticLocation location;
    private final List<DiagnosticProperty<?>> properties;
    private final String message;
    private final String severity;

    public ArchitectureModelDiagnostic(String code, String message, DiagnosticSeverity severity, Location location, Object[] args) {
        this.diagnosticInfo = new DiagnosticInfo(code, message, severity);
        this.location = location == null ? null : new DiagnosticLocation(location.lineRange(), location.textRange());
        this.properties = Collections.emptyList();
        this.message = MessageFormat.format(message, args);
        this.severity = severity.name();
    }

    public Location location() {
        return this.location;
    }

    public DiagnosticInfo diagnosticInfo() {
        return this.diagnosticInfo;
    }

    public String message() {
        return this.message;
    }

    public List<DiagnosticProperty<?>> properties() {
        return this.properties;
    }

    public String getSeverity() {
        return this.severity;
    }

    public String toString() {
        String severity = this.diagnosticInfo().severity().toString();
        return "[" + severity + "] " + this.message();
    }
}

