/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.architecturemodelgenerator.core.generators.service;

import io.ballerina.architecturemodelgenerator.core.generators.ModelGenerator;
import io.ballerina.architecturemodelgenerator.core.generators.service.nodevisitors.ServiceDeclarationNodeVisitor;
import io.ballerina.architecturemodelgenerator.core.model.service.Connection;
import io.ballerina.architecturemodelgenerator.core.model.service.Service;
import io.ballerina.compiler.syntax.tree.NodeVisitor;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.projects.DocumentId;
import io.ballerina.projects.Module;
import io.ballerina.projects.PackageCompilation;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class ServiceModelGenerator
extends ModelGenerator {
    private final Map<String, Service> services = new HashMap<String, Service>();
    private final List<Connection> dependencies = new LinkedList<Connection>();

    public ServiceModelGenerator(PackageCompilation packageCompilation, Module module) {
        super(packageCompilation, module);
    }

    public Map<String, Service> getServices() {
        return this.services;
    }

    public List<Connection> getDependencies() {
        return this.dependencies;
    }

    public void generate() {
        for (DocumentId documentId : this.getModule().documentIds()) {
            SyntaxTree syntaxTree = this.getModule().document(documentId).syntaxTree();
            Path filePath = this.getModuleRootPath().resolve(syntaxTree.filePath());
            ServiceDeclarationNodeVisitor serviceNodeVisitor = new ServiceDeclarationNodeVisitor(this.getPackageCompilation(), this.getSemanticModel(), syntaxTree, this.getModule().packageInstance(), filePath);
            syntaxTree.rootNode().accept((NodeVisitor)serviceNodeVisitor);
            serviceNodeVisitor.getServices().forEach(service -> this.services.put(service.getId(), (Service)service));
            this.dependencies.addAll(serviceNodeVisitor.getDependencies());
        }
    }
}

