/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.designmodelgenerator.core;

import io.ballerina.compiler.api.ModuleID;
import io.ballerina.compiler.api.SemanticModel;
import io.ballerina.compiler.api.symbols.IntersectionTypeSymbol;
import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.PathParameterSymbol;
import io.ballerina.compiler.api.symbols.ResourceMethodSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.api.symbols.resourcepath.PathRestParam;
import io.ballerina.compiler.api.symbols.resourcepath.PathSegmentList;
import io.ballerina.compiler.api.symbols.resourcepath.ResourcePath;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CommonUtils {
    private static final String CENTRAL_ICON_URL = "https://bcentral-packageicons.azureedge.net/images/%s_%s_%s.png";
    private static final Pattern FULLY_QUALIFIED_MODULE_ID_PATTERN = Pattern.compile("(\\w+)/([\\w.]+):([^:]+):(\\w+)[|]?");
    private static final Random random = new Random();

    public static TypeSymbol getRawType(TypeSymbol typeDescriptor) {
        if (typeDescriptor.typeKind() == TypeDescKind.INTERSECTION) {
            return CommonUtils.getRawType(((IntersectionTypeSymbol)typeDescriptor).effectiveTypeDescriptor());
        }
        if (typeDescriptor.typeKind() == TypeDescKind.TYPE_REFERENCE) {
            TypeReferenceTypeSymbol typeRef = (TypeReferenceTypeSymbol)typeDescriptor;
            if (typeRef.typeDescriptor().typeKind() == TypeDescKind.INTERSECTION) {
                return CommonUtils.getRawType(((IntersectionTypeSymbol)typeRef.typeDescriptor()).effectiveTypeDescriptor());
            }
            TypeSymbol rawType = typeRef.typeDescriptor();
            if (rawType.typeKind() == TypeDescKind.TYPE_REFERENCE) {
                return CommonUtils.getRawType(rawType);
            }
            return rawType;
        }
        return typeDescriptor;
    }

    public static String generateIcon(ModuleID moduleID) {
        return String.format(CENTRAL_ICON_URL, moduleID.orgName(), moduleID.packageName(), moduleID.version());
    }

    public static String generateIcon(TypeSymbol typeSymbol) {
        return typeSymbol.getModule().map(moduleSymbol -> CommonUtils.generateIcon(moduleSymbol.id())).orElse(null);
    }

    public static String generateUUID() {
        return new UUID(random.nextLong(), random.nextLong()).toString();
    }

    public static String getTypeSignature(TypeSymbol typeSymbol, ModuleInfo moduleInfo) {
        String text = typeSymbol.signature();
        StringBuilder newText = new StringBuilder();
        Matcher matcher = FULLY_QUALIFIED_MODULE_ID_PATTERN.matcher(text);
        int nextStart = 0;
        while (matcher.find()) {
            newText.append(text, nextStart, matcher.start(1));
            String modPart = matcher.group(2);
            int last = modPart.lastIndexOf(".");
            if (last != -1) {
                modPart = modPart.substring(last + 1);
            }
            String typeName = matcher.group(4);
            if (!modPart.equals(moduleInfo.packageName())) {
                newText.append(modPart);
                newText.append(":");
            }
            newText.append(typeName);
            nextStart = matcher.end(4);
        }
        if (nextStart != 0 && nextStart < text.length()) {
            newText.append(text.substring(nextStart));
        }
        return !newText.isEmpty() ? newText.toString() : text;
    }

    public static String getResourcePathStr(SemanticModel semanticModel, ResourceMethodSymbol resourceMethodSymbol) {
        io.ballerina.modelgenerator.commons.ModuleInfo moduleInfo = resourceMethodSymbol.getName().isPresent() ? io.ballerina.modelgenerator.commons.ModuleInfo.from((ModuleID)((ModuleSymbol)resourceMethodSymbol.getModule().get()).id()) : null;
        StringBuilder pathBuilder = new StringBuilder();
        ResourcePath resourcePath = resourceMethodSymbol.resourcePath();
        switch (resourcePath.kind()) {
            case PATH_SEGMENT_LIST: {
                PathSegmentList pathSegmentList = (PathSegmentList)resourcePath;
                boolean isFirstElement = true;
                for (Symbol pathSegment : pathSegmentList.list()) {
                    if (isFirstElement) {
                        isFirstElement = false;
                    } else {
                        pathBuilder.append("/");
                    }
                    if (pathSegment instanceof PathParameterSymbol) {
                        PathParameterSymbol pathParameterSymbol = (PathParameterSymbol)pathSegment;
                        String type = io.ballerina.modelgenerator.commons.CommonUtils.getTypeSignature((SemanticModel)semanticModel, (TypeSymbol)pathParameterSymbol.typeDescriptor(), (boolean)true, (io.ballerina.modelgenerator.commons.ModuleInfo)moduleInfo);
                        pathBuilder.append("[").append(type);
                        String paramName = pathParameterSymbol.getName().orElse("");
                        if (!paramName.isEmpty()) {
                            pathBuilder.append(" ").append(paramName);
                        }
                        pathBuilder.append("]");
                        continue;
                    }
                    pathBuilder.append(pathSegment.getName().orElse(""));
                }
                ((PathSegmentList)resourcePath).pathRestParameter().ifPresent(pathRestParameter -> {
                    String type = io.ballerina.modelgenerator.commons.CommonUtils.getTypeSignature((SemanticModel)semanticModel, (TypeSymbol)pathRestParameter.typeDescriptor(), (boolean)true, (io.ballerina.modelgenerator.commons.ModuleInfo)moduleInfo);
                    pathBuilder.append("[").append(type).append("...");
                    if (!pathRestParameter.isTypeOnlyParam()) {
                        pathBuilder.append(" ").append(pathRestParameter.getName().orElse(""));
                    }
                    pathBuilder.append("]");
                });
                break;
            }
            case PATH_REST_PARAM: {
                PathParameterSymbol pathRestParameter2 = ((PathRestParam)resourcePath).parameter();
                String type = io.ballerina.modelgenerator.commons.CommonUtils.getTypeSignature((SemanticModel)semanticModel, (TypeSymbol)pathRestParameter2.typeDescriptor(), (boolean)true, (io.ballerina.modelgenerator.commons.ModuleInfo)moduleInfo);
                pathBuilder.append("[").append(type).append("...");
                if (!pathRestParameter2.isTypeOnlyParam()) {
                    pathBuilder.append(" ").append(pathRestParameter2.getName().orElse(""));
                }
                pathBuilder.append("]");
                break;
            }
            case DOT_RESOURCE_PATH: {
                pathBuilder.append(".");
            }
        }
        return pathBuilder.toString();
    }

    public record ModuleInfo(String org, String packageName, String moduleName, String version) {
        public static ModuleInfo from(ModuleID moduleId) {
            return new ModuleInfo(moduleId.orgName(), moduleId.packageName(), moduleId.moduleName(), moduleId.version());
        }
    }
}

