/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api;

import io.ballerina.runtime.api.Environment;
import io.ballerina.runtime.api.Runtime;
import io.ballerina.runtime.api.concurrent.StrandMetadata;
import io.ballerina.runtime.api.types.ServiceType;
import io.ballerina.runtime.api.utils.TypeUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BError;
import io.ballerina.runtime.api.values.BObject;
import io.ballerina.stdlib.http.api.HttpCallableUnitCallback;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.nativeimpl.connection.Respond;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;

public class HttpResponseInterceptorUnitCallback
extends HttpCallableUnitCallback {
    private static final String ILLEGAL_FUNCTION_INVOKED = "illegal return: response has already been sent";
    private final HttpCarbonMessage requestMessage;
    private final BObject caller;
    private final BObject response;
    private final Environment environment;
    private final BObject requestCtx;
    private final boolean possibleLastInterceptor;

    public HttpResponseInterceptorUnitCallback(HttpCarbonMessage requestMessage, BObject caller, BObject response, Environment env, Runtime runtime, boolean possibleLastInterceptor) {
        super(requestMessage, runtime);
        this.requestMessage = requestMessage;
        this.requestCtx = (BObject)requestMessage.getProperty("RequestContext");
        this.caller = caller;
        this.response = response;
        this.environment = env;
        this.possibleLastInterceptor = possibleLastInterceptor;
    }

    @Override
    public void handleResult(Object result) {
        if (result instanceof BError) {
            this.requestMessage.setHttpStatusCode(500);
            this.invokeErrorInterceptors((BError)((Object)result), false);
            return;
        }
        if (this.possibleLastInterceptor) {
            this.cleanupRequestMessage();
        }
        this.validateResponseAndProceed(result);
    }

    @Override
    public void handlePanic(BError error) {
        this.cleanupRequestMessage();
        this.sendFailureResponse(error);
        System.exit(1);
    }

    @Override
    public void invokeErrorInterceptors(BError error, boolean isInternalError) {
        if (isInternalError) {
            this.requestMessage.setProperty("INTERNAL_ERROR", true);
        } else {
            this.requestMessage.removeProperty("INTERNAL_ERROR");
        }
        this.requestMessage.setProperty("INTERCEPTOR_SERVICE_ERROR", (Object)error);
        this.returnErrorResponse(error);
    }

    private void sendResponseToNextService() {
        Respond.nativeRespond(this.environment, this.caller, this.response);
    }

    private boolean alreadyResponded() {
        try {
            HttpUtil.methodInvocationCheck(this.requestMessage, 0, ILLEGAL_FUNCTION_INVOKED);
        }
        catch (BError e) {
            return true;
        }
        return false;
    }

    private void validateResponseAndProceed(Object result) {
        int interceptorId = this.getResponseInterceptorId();
        this.requestMessage.setProperty("RESPONSE_INTERCEPTOR_INDEX", interceptorId);
        BArray interceptors = (BArray)this.requestCtx.getNativeData("INTERCEPTORS");
        if (this.alreadyResponded()) {
            this.stopObserverContext();
            return;
        }
        if (result == null && interceptorId == -1) {
            this.sendResponseToNextService();
            return;
        }
        if (this.isServiceType(result)) {
            this.validateServiceReturnType(result, interceptorId, interceptors);
        } else {
            this.returnResponse(result);
        }
    }

    private boolean isServiceType(Object result) {
        return result instanceof BObject && TypeUtils.getType((Object)result) instanceof ServiceType;
    }

    private void validateServiceReturnType(Object result, int interceptorId, BArray interceptors) {
        if (interceptors != null && interceptorId < interceptors.size()) {
            Object interceptor = interceptors.get((long)interceptorId);
            if (result.equals(interceptor)) {
                this.sendResponseToNextService();
            } else {
                BError err = HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_INTERCEPTOR_RETURN_ERROR, "next interceptor service did not match with the configuration");
                this.invokeErrorInterceptors(err, true);
            }
        }
    }

    private void returnResponse(Object result) {
        Object[] paramFeed = new Object[]{result, null, null, null};
        this.invokeBalMethod(paramFeed, "returnResponse");
    }

    @Override
    public void invokeBalMethod(Object[] paramFeed, String methodName) {
        try {
            StrandMetadata metaData = new StrandMetadata(true, null);
            this.getRuntime().callMethod(this.caller, methodName, metaData, paramFeed);
            this.stopObserverContext();
        }
        catch (BError error) {
            this.sendFailureResponse(error);
        }
    }

    private int getResponseInterceptorId() {
        return Math.min((Integer)this.requestCtx.getNativeData("RESPONSE_INTERCEPTOR_INDEX"), (Integer)this.requestMessage.getProperty("RESPONSE_INTERCEPTOR_INDEX"));
    }

    public void returnErrorResponse(BError error) {
        Thread.startVirtualThread(() -> {
            Object[] paramFeed = new Object[]{error, null};
            this.invokeBalMethod(paramFeed, "returnErrorResponse");
        });
    }
}

