/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api;

import io.ballerina.runtime.api.types.MethodType;
import io.ballerina.runtime.api.types.ResourceMethodType;
import io.ballerina.stdlib.http.api.BallerinaConnectorException;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.InterceptorService;
import io.ballerina.stdlib.http.api.Resource;
import io.ballerina.stdlib.http.api.service.signature.ParamHandler;
import java.util.Collections;
import java.util.List;
import java.util.Locale;

public class InterceptorResource
implements Resource {
    private MethodType balResource;
    private List<String> methods;
    private String path;
    private ParamHandler paramHandler;
    private InterceptorService parentService;
    private String wildcardToken;
    private int pathParamCount;
    private boolean treatNilableAsOptional = true;

    protected InterceptorResource(MethodType resource, InterceptorService parentService, boolean fromListener) {
        this.balResource = resource;
        this.parentService = parentService;
        if (this.balResource instanceof ResourceMethodType) {
            this.validateAndPopulateResourcePath(fromListener);
            this.validateAndPopulateMethod();
        }
    }

    @Override
    public String getName() {
        return this.balResource.getName();
    }

    @Override
    public Object getCorsHeaders() {
        return null;
    }

    @Override
    public ParamHandler getParamHandler() {
        return this.paramHandler;
    }

    @Override
    public InterceptorService getParentService() {
        return this.parentService;
    }

    @Override
    public ResourceMethodType getBalResource() {
        return (ResourceMethodType)this.balResource;
    }

    @Override
    public List<String> getMethods() {
        return this.methods;
    }

    @Override
    public List<String> getConsumes() {
        return null;
    }

    @Override
    public List<String> getProduces() {
        return null;
    }

    @Override
    public List<String> getProducesSubTypes() {
        return null;
    }

    private void validateAndPopulateMethod() {
        String accessor = this.getBalResource().getAccessor();
        this.methods = HttpUtil.isDefaultResource(accessor) ? null : Collections.singletonList(accessor.toUpperCase(Locale.getDefault()));
    }

    public String getPath() {
        return this.path;
    }

    private void validateAndPopulateResourcePath(boolean fromListener) {
        ResourceMethodType resourceFunctionType = this.getBalResource();
        String[] paths = resourceFunctionType.getResourcePath();
        StringBuilder resourcePath = new StringBuilder();
        int count = 0;
        for (String segment : paths) {
            resourcePath.append("/");
            if ("^".equals(segment)) {
                String pathSegment = resourceFunctionType.getParamNames()[count++];
                resourcePath.append("{").append(pathSegment).append("}");
                continue;
            }
            if ("^^".equals(segment)) {
                this.wildcardToken = resourceFunctionType.getParamNames()[count++];
                resourcePath.append("*");
                continue;
            }
            if (".".equals(segment)) break;
            resourcePath.append(HttpUtil.unescapeAndEncodeValue(segment));
        }
        this.path = resourcePath.toString().replaceAll("(?<!(http:|https:))//", "/");
        if (fromListener && !this.path.equals("/*")) {
            throw new BallerinaConnectorException("interceptor services engaged in listener level can only support resource method with default path([string... path])");
        }
        this.pathParamCount = count;
    }

    @Override
    public boolean isTreatNilableAsOptional() {
        return this.treatNilableAsOptional;
    }

    public static InterceptorResource buildInterceptorResource(MethodType resource, InterceptorService interceptorService, boolean fromListener) {
        InterceptorResource interceptorResource = new InterceptorResource(resource, interceptorService, fromListener);
        interceptorResource.prepareAndValidateSignatureParams();
        return interceptorResource;
    }

    private void prepareAndValidateSignatureParams() {
        this.paramHandler = new ParamHandler(this.getBalResource(), this.pathParamCount, false, false);
    }

    @Override
    public String getWildcardToken() {
        return this.wildcardToken;
    }
}

