/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.api.service.signature;

import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.utils.ValueUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BNever;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.http.api.HttpErrorType;
import io.ballerina.stdlib.http.api.HttpUtil;
import io.ballerina.stdlib.http.api.service.signature.ParamHandler;
import io.ballerina.stdlib.http.api.service.signature.ParamUtils;
import io.ballerina.stdlib.http.api.service.signature.Parameter;
import io.ballerina.stdlib.http.api.service.signature.QueryParam;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import java.util.ArrayList;
import java.util.List;

public class AllQueryParams
implements Parameter {
    private final List<QueryParam> allQueryParams = new ArrayList<QueryParam>();

    @Override
    public String getTypeName() {
        return "query";
    }

    public void add(QueryParam queryParam) {
        this.allQueryParams.add(queryParam);
    }

    boolean isNotEmpty() {
        return !this.allQueryParams.isEmpty();
    }

    public void populateFeed(HttpCarbonMessage httpCarbonMessage, ParamHandler paramHandler, Object[] paramFeed, boolean treatNilableAsOptional) {
        BMap<BString, Object> urlQueryParams = paramHandler.getQueryParams(httpCarbonMessage.getProperty("RAW_QUERY_STR"));
        for (QueryParam queryParam : this.allQueryParams) {
            Object castedQueryValue;
            String token = queryParam.getToken();
            int index = queryParam.getIndex();
            boolean queryExist = urlQueryParams.containsKey((Object)StringUtils.fromString((String)token));
            Object queryValue = urlQueryParams.get((Object)StringUtils.fromString((String)token));
            if (queryValue == null) {
                if (queryParam.isDefaultable()) {
                    queryParam.validateConstraints(queryParam.getOriginalType().getZeroValue());
                    paramFeed[index] = BNever.getValue();
                    continue;
                }
                if (queryParam.isNilable() && (treatNilableAsOptional || queryExist)) {
                    paramFeed[index] = null;
                    continue;
                }
                String message = "no query param value found for '" + token + "'";
                throw HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_QUERY_PARAM_BINDING_ERROR, message);
            }
            try {
                BArray queryValueArr = (BArray)queryValue;
                Object parsedQueryValue = queryParam.isArray() ? ParamUtils.castParamArray(queryParam.getEffectiveTypeTag(), queryValueArr.getStringArray()) : ParamUtils.castParam(queryParam.getEffectiveTypeTag(), queryValueArr.getBString(0L).getValue());
                castedQueryValue = ValueUtils.convert((Object)parsedQueryValue, (Type)queryParam.getOriginalType());
            }
            catch (Exception ex) {
                String message = "error in casting query param : '" + token + "'";
                throw HttpUtil.createHttpStatusCodeError(HttpErrorType.INTERNAL_QUERY_PARAM_BINDING_ERROR, message, null, HttpUtil.createError(ex));
            }
            paramFeed[index] = queryParam.validateConstraints(castedQueryValue);
        }
    }
}

