/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.listener.states.http2;

import io.ballerina.stdlib.http.api.logging.accesslog.ListenerHttpAccessLogger;
import io.ballerina.stdlib.http.transport.contract.HttpResponseFuture;
import io.ballerina.stdlib.http.transport.contract.ServerConnectorFuture;
import io.ballerina.stdlib.http.transport.contract.exceptions.ServerConnectorException;
import io.ballerina.stdlib.http.transport.contractimpl.Http2OutboundRespListener;
import io.ballerina.stdlib.http.transport.contractimpl.common.Util;
import io.ballerina.stdlib.http.transport.contractimpl.common.states.Http2MessageStateContext;
import io.ballerina.stdlib.http.transport.contractimpl.common.states.Http2StateUtil;
import io.ballerina.stdlib.http.transport.contractimpl.listener.http2.Http2SourceHandler;
import io.ballerina.stdlib.http.transport.contractimpl.listener.states.http2.ListenerState;
import io.ballerina.stdlib.http.transport.contractimpl.listener.states.http2.ReceivingEntityBody;
import io.ballerina.stdlib.http.transport.contractimpl.listener.states.http2.ResponseCompleted;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.Http2DataEventListener;
import io.ballerina.stdlib.http.transport.message.Http2DataFrame;
import io.ballerina.stdlib.http.transport.message.Http2HeadersFrame;
import io.ballerina.stdlib.http.transport.message.Http2PushPromise;
import io.ballerina.stdlib.http.transport.message.HttpCarbonMessage;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http2.Http2Connection;
import io.netty.handler.codec.http2.Http2ConnectionEncoder;
import io.netty.handler.codec.http2.Http2Error;
import io.netty.handler.codec.http2.Http2Exception;
import io.netty.handler.codec.http2.Http2Headers;
import io.netty.handler.codec.http2.HttpConversionUtil;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SendingEntityBody
implements ListenerState {
    private static final Logger LOG = LoggerFactory.getLogger(SendingEntityBody.class);
    private final Http2MessageStateContext http2MessageStateContext;
    private final ChannelHandlerContext ctx;
    private final Http2Connection conn;
    private final Http2ConnectionEncoder encoder;
    private final HttpResponseFuture outboundRespStatusFuture;
    private final HttpCarbonMessage inboundRequestMsg;
    private final int originalStreamId;
    private final Http2OutboundRespListener http2OutboundRespListener;
    private HttpCarbonMessage outboundResponseMsg;
    private ListenerHttpAccessLogger accessLogger;

    SendingEntityBody(Http2OutboundRespListener http2OutboundRespListener, Http2MessageStateContext http2MessageStateContext) {
        this.http2OutboundRespListener = http2OutboundRespListener;
        this.http2MessageStateContext = http2MessageStateContext;
        this.ctx = http2OutboundRespListener.getChannelHandlerContext();
        this.conn = http2OutboundRespListener.getConnection();
        this.encoder = http2OutboundRespListener.getEncoder();
        this.inboundRequestMsg = http2OutboundRespListener.getInboundRequestMsg();
        this.outboundRespStatusFuture = this.inboundRequestMsg.getHttpOutboundRespStatusFuture();
        this.originalStreamId = http2OutboundRespListener.getOriginalStreamId();
        if (http2OutboundRespListener.getServerChannelInitializer().isHttpAccessLogEnabled()) {
            this.accessLogger = new ListenerHttpAccessLogger(http2OutboundRespListener.getInboundRequestArrivalTime(), http2OutboundRespListener.getRemoteAddress());
        }
    }

    @Override
    public void readInboundRequestHeaders(ChannelHandlerContext ctx, Http2HeadersFrame headersFrame) {
        LOG.warn("readInboundRequestHeaders is not a dependant action of this state");
    }

    @Override
    public void readInboundRequestBody(Http2SourceHandler http2SourceHandler, Http2DataFrame dataFrame) throws Http2Exception, ServerConnectorException {
        this.http2MessageStateContext.setListenerState(new ReceivingEntityBody(this.http2MessageStateContext));
        this.http2MessageStateContext.getListenerState().readInboundRequestBody(http2SourceHandler, dataFrame);
    }

    @Override
    public void writeOutboundResponseHeaders(Http2OutboundRespListener http2OutboundRespListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent, int streamId) {
        LOG.warn("writeOutboundResponseHeaders is not a dependant action of this state");
    }

    @Override
    public void writeOutboundResponseBody(Http2OutboundRespListener http2OutboundRespListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent, int streamId) throws Http2Exception {
        this.outboundResponseMsg = outboundResponseMsg;
        this.writeContent(http2OutboundRespListener, outboundResponseMsg, httpContent, streamId);
    }

    @Override
    public void writeOutboundPromise(Http2OutboundRespListener http2OutboundRespListener, Http2PushPromise pushPromise) throws Http2Exception {
        LOG.warn("writeOutboundPromise is not a dependant action of this state");
        throw new Http2Exception(Http2Error.PROTOCOL_ERROR, "WriteOutboundPromise is not a dependant action of SendingEntityBody state");
    }

    @Override
    public void handleStreamTimeout(ServerConnectorFuture serverConnectorFuture, ChannelHandlerContext ctx, Http2OutboundRespListener http2OutboundRespListener, int streamId) {
        try {
            serverConnectorFuture.notifyErrorListener(new ServerConnectorException("Idle timeout triggered while writing outbound response entity body"));
            LOG.error("Idle timeout triggered while writing outbound response entity body");
        }
        catch (ServerConnectorException e) {
            LOG.error("Error while notifying error state to server-connector listener");
        }
    }

    @Override
    public void handleAbruptChannelClosure(ServerConnectorFuture serverConnectorFuture, ChannelHandlerContext ctx, Http2OutboundRespListener http2OutboundRespListener, int streamId) {
        IOException connectionClose = new IOException("Remote client closed the connection while writing outbound response entity body");
        this.outboundResponseMsg.setIoException(connectionClose);
        this.outboundRespStatusFuture.notifyHttpListener(connectionClose);
        LOG.error("Remote client closed the connection while writing outbound response entity body");
    }

    @Override
    public void handleClientGoAway(ServerConnectorFuture serverConnectorFuture, ChannelHandlerContext channelHandlerContext, Http2OutboundRespListener http2OutboundRespListener, Integer streamId) {
        IOException connectionClose = new IOException("Remote client sent GOAWAY while writing outbound response entity body");
        this.outboundResponseMsg.setIoException(connectionClose);
        this.outboundRespStatusFuture.notifyHttpListener(connectionClose);
        LOG.error("Remote client sent GOAWAY while writing outbound response entity body");
    }

    private void writeContent(Http2OutboundRespListener http2OutboundRespListener, HttpCarbonMessage outboundResponseMsg, HttpContent httpContent, int streamId) throws Http2Exception {
        if (httpContent instanceof LastHttpContent) {
            DefaultLastHttpContent lastContent = httpContent == LastHttpContent.EMPTY_LAST_CONTENT ? new DefaultLastHttpContent() : (LastHttpContent)httpContent;
            HttpHeaders trailers = lastContent.trailingHeaders();
            trailers.add(outboundResponseMsg.getTrailerHeaders());
            boolean endStream = trailers.isEmpty();
            this.writeData((HttpContent)lastContent, streamId, endStream);
            if (!trailers.isEmpty()) {
                Http2Headers http2Trailers = HttpConversionUtil.toHttp2Headers((HttpHeaders)trailers, (boolean)true);
                Http2StateUtil.writeHttp2ResponseHeaders(this.ctx, this.encoder, this.outboundRespStatusFuture, streamId, http2Trailers, true, http2OutboundRespListener, this.inboundRequestMsg);
            }
            http2OutboundRespListener.removeDefaultResponseWriter();
            if (this.accessLogger != null) {
                if (this.originalStreamId != streamId) {
                    LOG.debug("Access logging skipped for server push response");
                    return;
                }
                this.accessLogger.logAccessInfo(http2OutboundRespListener.getInboundRequestMsg(), outboundResponseMsg);
            }
            this.http2MessageStateContext.setListenerState(new ResponseCompleted(http2OutboundRespListener, this.http2MessageStateContext));
        } else {
            this.writeData(httpContent, streamId, false);
        }
    }

    private void writeData(HttpContent httpContent, int streamId, boolean endStream) throws Http2Exception {
        if (this.accessLogger != null) {
            this.accessLogger.updateContentLength(httpContent);
        }
        Http2StateUtil.validatePromisedStreamState(this.originalStreamId, streamId, this.conn, this.inboundRequestMsg);
        ByteBuf content = httpContent.content();
        for (Http2DataEventListener dataEventListener : this.http2OutboundRespListener.getHttp2ServerChannel().getDataEventListeners()) {
            if (!dataEventListener.onDataWrite(this.ctx, streamId, content, endStream)) break;
        }
        ChannelFuture channelFuture = this.encoder.writeData(this.ctx, streamId, content, 0, endStream, this.ctx.newPromise());
        this.encoder.flowController().writePendingBytes();
        this.ctx.flush();
        if (endStream) {
            this.http2OutboundRespListener.getHttp2ServerChannel().getStreamIdRequestMap().remove(streamId);
            Util.checkForResponseWriteStatus(this.inboundRequestMsg, this.outboundRespStatusFuture, channelFuture);
        } else {
            Util.addResponseWriteFailureListener(this.outboundRespStatusFuture, channelFuture, this.http2OutboundRespListener);
        }
    }
}

