/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.sender.states.http2;

import io.ballerina.stdlib.http.api.logging.accesslog.SenderHttpAccessLogger;
import io.ballerina.stdlib.http.transport.contractimpl.common.states.Http2MessageStateContext;
import io.ballerina.stdlib.http.transport.contractimpl.common.states.Http2StateUtil;
import io.ballerina.stdlib.http.transport.contractimpl.common.states.StateUtil;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.Http2ClientChannel;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.Http2TargetHandler;
import io.ballerina.stdlib.http.transport.contractimpl.sender.http2.OutboundMsgHolder;
import io.ballerina.stdlib.http.transport.contractimpl.sender.states.http2.EntityBodyReceived;
import io.ballerina.stdlib.http.transport.contractimpl.sender.states.http2.ReceivingHeaders;
import io.ballerina.stdlib.http.transport.contractimpl.sender.states.http2.SenderState;
import io.ballerina.stdlib.http.transport.contractimpl.sender.states.http2.SendingEntityBody;
import io.ballerina.stdlib.http.transport.message.Http2DataFrame;
import io.ballerina.stdlib.http.transport.message.Http2HeadersFrame;
import io.ballerina.stdlib.http.transport.message.Http2PushPromise;
import io.ballerina.stdlib.http.transport.message.HttpCarbonResponse;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultLastHttpContent;
import io.netty.handler.codec.http.HttpContent;
import io.netty.handler.codec.http2.Http2Exception;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ReceivingEntityBody
implements SenderState {
    private static final Logger LOG = LoggerFactory.getLogger(ReceivingEntityBody.class);
    private final Http2TargetHandler http2TargetHandler;
    private final Http2ClientChannel http2ClientChannel;
    private final Http2TargetHandler.Http2RequestWriter http2RequestWriter;
    private SenderHttpAccessLogger accessLogger;

    ReceivingEntityBody(Http2TargetHandler http2TargetHandler, Http2TargetHandler.Http2RequestWriter http2RequestWriter) {
        this.http2TargetHandler = http2TargetHandler;
        this.http2RequestWriter = http2RequestWriter;
        this.http2ClientChannel = http2TargetHandler.getHttp2ClientChannel();
        if (http2TargetHandler.getHttpClientChannelInitializer().isHttpAccessLogEnabled()) {
            this.accessLogger = new SenderHttpAccessLogger(http2TargetHandler.getHttp2ClientChannel().getChannel().remoteAddress());
        }
    }

    @Override
    public void writeOutboundRequestHeaders(ChannelHandlerContext ctx, HttpContent httpContent) {
        LOG.warn("writeOutboundRequestHeaders is not a dependant action of this state");
    }

    @Override
    public void writeOutboundRequestBody(ChannelHandlerContext ctx, HttpContent httpContent, Http2MessageStateContext http2MessageStateContext) throws Http2Exception {
        if (this.http2RequestWriter != null) {
            http2MessageStateContext.setSenderState(new SendingEntityBody(this.http2TargetHandler, this.http2RequestWriter));
            http2MessageStateContext.getSenderState().writeOutboundRequestBody(ctx, httpContent, http2MessageStateContext);
        } else {
            Http2StateUtil.releaseContent(httpContent);
        }
    }

    @Override
    public void readInboundResponseHeaders(ChannelHandlerContext ctx, Http2HeadersFrame http2HeadersFrame, OutboundMsgHolder outboundMsgHolder, boolean serverPush, Http2MessageStateContext http2MessageStateContext) throws Http2Exception {
        http2MessageStateContext.setSenderState(new ReceivingHeaders(this.http2TargetHandler, this.http2RequestWriter));
        http2MessageStateContext.getSenderState().readInboundResponseHeaders(ctx, http2HeadersFrame, outboundMsgHolder, serverPush, http2MessageStateContext);
    }

    @Override
    public void readInboundResponseBody(ChannelHandlerContext ctx, Http2DataFrame http2DataFrame, OutboundMsgHolder outboundMsgHolder, boolean serverPush, Http2MessageStateContext http2MessageStateContext) {
        this.onDataRead(http2DataFrame, outboundMsgHolder, serverPush, http2MessageStateContext);
    }

    @Override
    public void readInboundPromise(ChannelHandlerContext ctx, Http2PushPromise http2PushPromise, OutboundMsgHolder outboundMsgHolder) {
        LOG.warn("readInboundPromise is not a dependant action of this state");
    }

    @Override
    public void handleStreamTimeout(OutboundMsgHolder outboundMsgHolder, boolean serverPush, ChannelHandlerContext ctx, int streamId) {
    }

    @Override
    public void handleConnectionClose(OutboundMsgHolder outboundMsgHolder) {
        StateUtil.handleIncompleteInboundMessage(outboundMsgHolder.getResponse(), "Remote host closed the connection while reading inbound response body");
    }

    @Override
    public void handleServerGoAway(OutboundMsgHolder outboundMsgHolder) {
        StateUtil.handleIncompleteInboundMessage(outboundMsgHolder.getResponse(), "Remote host sent GOAWAY while reading inbound response body");
    }

    @Override
    public void handleRstStream(OutboundMsgHolder outboundMsgHolder) {
        StateUtil.handleIncompleteInboundMessage(outboundMsgHolder.getResponse(), "Remote host sent RST_STREAM while reading inbound response body");
    }

    private void onDataRead(Http2DataFrame http2DataFrame, OutboundMsgHolder outboundMsgHolder, boolean serverPush, Http2MessageStateContext http2MessageStateContext) {
        int streamId = http2DataFrame.getStreamId();
        ByteBuf data = http2DataFrame.getData();
        if (this.accessLogger != null) {
            this.accessLogger.updateContentLength(data);
        }
        boolean endOfStream = http2DataFrame.isEndOfStream();
        if (serverPush) {
            this.onServerPushDataRead(outboundMsgHolder, streamId, endOfStream, data);
        } else {
            this.onResponseDataRead(outboundMsgHolder, streamId, endOfStream, data);
        }
        if (endOfStream) {
            if (this.accessLogger != null) {
                this.accessLogger.updateAccessLogInfo(outboundMsgHolder.getRequest(), outboundMsgHolder.getResponse());
            }
            http2MessageStateContext.setSenderState(new EntityBodyReceived(this.http2TargetHandler, this.http2RequestWriter));
        }
    }

    private void onServerPushDataRead(OutboundMsgHolder outboundMsgHolder, int streamId, boolean endOfStream, ByteBuf data) {
        HttpCarbonResponse responseMessage = outboundMsgHolder.getPushResponse(streamId);
        if (endOfStream) {
            responseMessage.addHttpContent((HttpContent)new DefaultLastHttpContent(data.retain()));
            this.http2ClientChannel.removePromisedMessage(streamId);
            responseMessage.setLastHttpContentArrived();
        } else {
            responseMessage.addHttpContent((HttpContent)new DefaultHttpContent(data.retain()));
        }
    }

    private void onResponseDataRead(OutboundMsgHolder outboundMsgHolder, int streamId, boolean endOfStream, ByteBuf data) {
        HttpCarbonResponse responseMessage = outboundMsgHolder.getResponse();
        if (endOfStream) {
            responseMessage.addHttpContent((HttpContent)new DefaultLastHttpContent(data.retain()));
            this.http2ClientChannel.removeInFlightMessage(streamId);
            responseMessage.setLastHttpContentArrived();
        } else {
            responseMessage.addHttpContent((HttpContent)new DefaultHttpContent(data.retain()));
        }
    }
}

