/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.http.transport.contractimpl.websocket;

import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketControlMessage;
import io.ballerina.stdlib.http.transport.contract.websocket.WebSocketControlSignal;
import io.ballerina.stdlib.http.transport.contractimpl.websocket.DefaultWebSocketMessage;
import io.ballerina.stdlib.http.transport.contractimpl.websocket.message.DefaultWebSocketBinaryMessage;
import io.ballerina.stdlib.http.transport.contractimpl.websocket.message.DefaultWebSocketControlMessage;
import io.ballerina.stdlib.http.transport.contractimpl.websocket.message.DefaultWebSocketTextMessage;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import java.nio.ByteBuffer;

public class WebSocketUtil {
    private WebSocketUtil() {
    }

    public static String getChannelId(ChannelHandlerContext ctx) {
        return ctx.channel().id().asLongText();
    }

    public static WebSocketControlMessage getWebSocketControlMessage(WebSocketFrame webSocketFrame, WebSocketControlSignal controlSignal) {
        ByteBuf content = webSocketFrame.content();
        ByteBuffer clonedContent = WebSocketUtil.getClonedByteBuf(content);
        DefaultWebSocketControlMessage webSocketControlMessage = new DefaultWebSocketControlMessage(controlSignal, clonedContent);
        webSocketFrame.release();
        return webSocketControlMessage;
    }

    public static DefaultWebSocketMessage getWebSocketMessage(WebSocketFrame frame, String text, boolean isFinalFragment) {
        DefaultWebSocketTextMessage webSocketTextMessage = new DefaultWebSocketTextMessage(text, isFinalFragment);
        frame.release();
        return webSocketTextMessage;
    }

    public static DefaultWebSocketMessage getWebSocketMessage(WebSocketFrame webSocketFrame, ByteBuf content, boolean finalFragment) {
        ByteBuffer clonedContent = WebSocketUtil.getClonedByteBuf(content);
        DefaultWebSocketBinaryMessage webSocketBinaryMessage = new DefaultWebSocketBinaryMessage(clonedContent, finalFragment);
        webSocketFrame.release();
        return webSocketBinaryMessage;
    }

    private static ByteBuffer getClonedByteBuf(ByteBuf buf) {
        ByteBuffer originalContent = buf.nioBuffer();
        ByteBuffer clonedContent = ByteBuffer.allocate(originalContent.capacity());
        originalContent.rewind();
        clonedContent.put(originalContent);
        originalContent.rewind();
        clonedContent.flip();
        return clonedContent;
    }
}

