/*
 * Decompiled with CFR 0.152.
 */
package de.odysseus.staxon.event;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.xml.namespace.NamespaceContext;
import javax.xml.namespace.QName;
import javax.xml.stream.Location;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.Characters;
import javax.xml.stream.events.Comment;
import javax.xml.stream.events.EndDocument;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.EntityDeclaration;
import javax.xml.stream.events.EntityReference;
import javax.xml.stream.events.Namespace;
import javax.xml.stream.events.ProcessingInstruction;
import javax.xml.stream.events.StartDocument;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import javax.xml.stream.util.XMLEventAllocator;
import javax.xml.stream.util.XMLEventConsumer;

public class SimpleXMLEventAllocator
implements XMLEventAllocator {
    @Override
    public XMLEventAllocator newInstance() {
        return this;
    }

    @Override
    public XMLEvent allocate(XMLStreamReader reader) throws XMLStreamException {
        switch (reader.getEventType()) {
            case 4: 
            case 6: 
            case 12: {
                return new CharactersEvent(reader);
            }
            case 5: {
                return new CommentEvent(reader);
            }
            case 11: {
                throw new UnsupportedOperationException();
            }
            case 8: {
                return new EndDocumentEvent(reader);
            }
            case 2: {
                return new EndElementEvent(reader);
            }
            case 9: {
                return new EntityReferenceEvent(reader);
            }
            case 14: {
                throw new UnsupportedOperationException();
            }
            case 3: {
                return new ProcessingInstructionEvent(reader);
            }
            case 7: {
                return new StartDocumentEvent(reader);
            }
            case 1: {
                return new StartElementEvent(reader);
            }
        }
        throw new XMLStreamException("Unexpected event type: " + reader.getEventType());
    }

    @Override
    public void allocate(XMLStreamReader reader, XMLEventConsumer consumer) throws XMLStreamException {
        consumer.add(this.allocate(reader));
    }

    static class StartElementEvent
    extends AbstractXMLEvent
    implements StartElement {
        final QName name;
        final List<AttributeEvent> attributes;
        final List<NamespaceEvent> namespaces;
        final NamespaceContext context;

        StartElementEvent(XMLStreamReader reader) {
            super(reader.getEventType(), reader.getLocation());
            int i;
            assert (this.eventType == 1);
            this.name = reader.getName();
            this.context = reader.getNamespaceContext();
            if (reader.getAttributeCount() == 0) {
                this.attributes = Collections.emptyList();
            } else {
                this.attributes = new ArrayList<AttributeEvent>(reader.getAttributeCount());
                for (i = 0; i < reader.getAttributeCount(); ++i) {
                    this.attributes.add(new AttributeEvent(this.location, reader.getAttributeName(i), reader.getAttributeValue(i), reader.isAttributeSpecified(i)));
                }
            }
            if (reader.getNamespaceCount() == 0) {
                this.namespaces = Collections.emptyList();
            } else {
                this.namespaces = new ArrayList<NamespaceEvent>(reader.getNamespaceCount());
                for (i = 0; i < reader.getNamespaceCount(); ++i) {
                    this.namespaces.add(new NamespaceEvent(this.location, reader.getNamespaceURI(i), reader.getNamespacePrefix(i)));
                }
            }
        }

        StartElementEvent(Location location, QName name, Iterator<AttributeEvent> attributes, Iterator<NamespaceEvent> namespaces, NamespaceContext context) {
            super(1, location);
            this.name = name;
            this.context = context;
            this.attributes = StartElementEvent.toList(attributes);
            this.namespaces = StartElementEvent.toList(namespaces);
        }

        @Override
        public Attribute getAttributeByName(QName name) {
            for (AttributeEvent attribute : this.attributes) {
                if (!attribute.getName().equals(name)) continue;
                return attribute;
            }
            return null;
        }

        public Iterator<?> getAttributes() {
            return this.attributes.iterator();
        }

        @Override
        public QName getName() {
            return this.name;
        }

        @Override
        public NamespaceContext getNamespaceContext() {
            return this.context;
        }

        public Iterator<?> getNamespaces() {
            return this.namespaces.iterator();
        }

        @Override
        public String getNamespaceURI(String prefix) {
            for (NamespaceEvent namespace : this.namespaces) {
                if (!namespace.getPrefix().equals(prefix)) continue;
                return namespace.getNamespaceURI();
            }
            return null;
        }

        @Override
        void writeAsEncodedUnicodeInternal(Writer writer) throws IOException {
            writer.write(60);
            if (!"".equals(this.name.getPrefix())) {
                writer.write(this.name.getPrefix());
                writer.write(58);
            }
            writer.write(this.name.getLocalPart());
            for (NamespaceEvent namespace : this.namespaces) {
                writer.write(32);
                namespace.writeAsEncodedUnicodeInternal(writer);
            }
            for (AttributeEvent attribute : this.attributes) {
                if (!attribute.isSpecified()) continue;
                writer.write(32);
                attribute.writeAsEncodedUnicodeInternal(writer);
            }
            writer.write(62);
        }
    }

    static class StartDocumentEvent
    extends AbstractXMLEvent
    implements StartDocument {
        final String encodingScheme;
        final String version;
        final Boolean standalone;

        StartDocumentEvent(XMLStreamReader reader) {
            super(reader.getEventType(), reader.getLocation());
            assert (this.eventType == 7);
            this.encodingScheme = reader.getCharacterEncodingScheme();
            this.version = reader.getVersion() == null ? "1.0" : reader.getVersion();
            this.standalone = reader.standaloneSet() ? Boolean.valueOf(reader.isStandalone()) : null;
        }

        StartDocumentEvent(Location location, String encoding, String version, Boolean standalone) {
            super(7, location);
            this.encodingScheme = encoding;
            this.version = version == null ? "1.0" : version;
            this.standalone = standalone;
        }

        @Override
        public String getCharacterEncodingScheme() {
            return this.encodingSet() ? this.encodingScheme : "UTF-8";
        }

        @Override
        public boolean encodingSet() {
            return this.encodingScheme != null;
        }

        @Override
        public String getVersion() {
            return this.version;
        }

        @Override
        public boolean isStandalone() {
            return this.standaloneSet() ? this.standalone : false;
        }

        @Override
        public boolean standaloneSet() {
            return this.standalone != null;
        }

        @Override
        public String getSystemId() {
            return this.location.getSystemId();
        }

        @Override
        void writeAsEncodedUnicodeInternal(Writer writer) throws IOException {
            writer.write("<?xml version=\"");
            writer.write(this.version);
            writer.write(34);
            if (this.encodingSet()) {
                writer.write(" encoding=\"");
                writer.write(this.encodingScheme);
                writer.write(34);
            }
            if (this.standaloneSet()) {
                writer.write(" standalone=\"");
                writer.write(this.standalone != false ? "yes" : "no");
                writer.write(34);
            }
            writer.write("?>");
        }
    }

    static class ProcessingInstructionEvent
    extends AbstractXMLEvent
    implements ProcessingInstruction {
        final String target;
        final String data;

        ProcessingInstructionEvent(XMLStreamReader reader) {
            super(reader.getEventType(), reader.getLocation());
            assert (this.eventType == 3);
            this.target = reader.getPITarget();
            this.data = reader.getPIData();
        }

        ProcessingInstructionEvent(Location location, String target, String data) {
            super(3, location);
            this.target = target;
            this.data = data;
        }

        @Override
        public String getTarget() {
            return this.target;
        }

        @Override
        public String getData() {
            return this.data;
        }

        @Override
        void writeAsEncodedUnicodeInternal(Writer writer) throws IOException {
            writer.write("<?");
            writer.write(this.target);
            if (this.data != null) {
                writer.write(32);
                writer.write(this.data.trim());
            }
            writer.write("?>");
        }
    }

    static class NamespaceEvent
    extends AttributeEvent
    implements Namespace {
        static QName createName(String prefix) {
            if (prefix == null || "".equals(prefix)) {
                return new QName("http://www.w3.org/2000/xmlns/", "xmlns");
            }
            return new QName("http://www.w3.org/2000/xmlns/", prefix, "xmlns");
        }

        NamespaceEvent(Location location, String namespaceURI, String prefix) {
            super(13, location, NamespaceEvent.createName(prefix), namespaceURI, true);
        }

        @Override
        public String getPrefix() {
            return this.isDefaultNamespaceDeclaration() ? "" : this.getName().getLocalPart();
        }

        @Override
        public String getNamespaceURI() {
            return this.getValue();
        }

        @Override
        public boolean isDefaultNamespaceDeclaration() {
            return "".equals(this.getName().getPrefix());
        }
    }

    static class EntityReferenceEvent
    extends AbstractXMLEvent
    implements EntityReference {
        final String name;
        final EntityDeclaration declaration;

        EntityReferenceEvent(XMLStreamReader reader) {
            super(reader.getEventType(), reader.getLocation());
            assert (this.eventType == 9);
            this.name = reader.getText();
            this.declaration = null;
        }

        EntityReferenceEvent(Location location, String name, EntityDeclaration declaration) {
            super(9, location);
            this.name = name;
            this.declaration = declaration;
        }

        @Override
        public EntityDeclaration getDeclaration() {
            return this.declaration;
        }

        @Override
        public String getName() {
            return this.name;
        }

        @Override
        void writeAsEncodedUnicodeInternal(Writer writer) throws IOException {
            writer.write(38);
            writer.write(this.name);
            writer.write(59);
        }
    }

    static class EndElementEvent
    extends AbstractXMLEvent
    implements EndElement {
        final QName name;
        final List<NamespaceEvent> namespaces;

        EndElementEvent(XMLStreamReader reader) {
            super(reader.getEventType(), reader.getLocation());
            assert (this.eventType == 2);
            this.name = reader.getName();
            if (reader.getNamespaceCount() == 0) {
                this.namespaces = Collections.emptyList();
            } else {
                this.namespaces = new ArrayList<NamespaceEvent>(reader.getNamespaceCount());
                for (int i = 0; i < reader.getNamespaceCount(); ++i) {
                    this.namespaces.add(new NamespaceEvent(this.location, reader.getNamespaceURI(i), reader.getNamespacePrefix(i)));
                }
            }
        }

        EndElementEvent(Location location, QName name, Iterator<NamespaceEvent> namespaces) {
            super(2, location);
            this.name = name;
            this.namespaces = EndElementEvent.toList(namespaces);
        }

        @Override
        public QName getName() {
            return this.name;
        }

        public Iterator<?> getNamespaces() {
            return this.namespaces.iterator();
        }

        @Override
        void writeAsEncodedUnicodeInternal(Writer writer) throws IOException {
            writer.write("</");
            if (!"".equals(this.name.getPrefix())) {
                writer.write(this.name.getPrefix());
                writer.write(58);
            }
            writer.write(this.name.getLocalPart());
            writer.write(62);
        }
    }

    static class EndDocumentEvent
    extends AbstractXMLEvent
    implements EndDocument {
        EndDocumentEvent(XMLStreamReader reader) {
            super(reader.getEventType(), reader.getLocation());
            assert (this.eventType == 8);
        }

        EndDocumentEvent(Location location) {
            super(8, location);
        }

        @Override
        void writeAsEncodedUnicodeInternal(Writer writer) {
        }
    }

    static class CommentEvent
    extends AbstractXMLEvent
    implements Comment {
        final String text;

        CommentEvent(XMLStreamReader reader) {
            super(reader.getEventType(), reader.getLocation());
            assert (this.eventType == 5);
            this.text = reader.getText();
        }

        CommentEvent(Location location, String text) {
            super(5, location);
            this.text = text;
        }

        @Override
        public String getText() {
            return this.text;
        }

        @Override
        void writeAsEncodedUnicodeInternal(Writer writer) throws IOException {
            writer.write("<!--");
            writer.write(this.text);
            writer.write("-->");
        }
    }

    static class CharactersEvent
    extends AbstractXMLEvent
    implements Characters {
        final String data;
        final boolean whitespace;

        CharactersEvent(XMLStreamReader reader) {
            this(reader.getEventType(), reader.getLocation(), reader.getText(), reader.isWhiteSpace());
        }

        CharactersEvent(int eventType, Location location, String data, boolean whitespace) {
            super(eventType, location);
            assert (eventType == 4 || eventType == 12 || eventType == 6);
            this.data = data;
            this.whitespace = whitespace;
        }

        @Override
        public String getData() {
            return this.data;
        }

        @Override
        public boolean isCData() {
            return this.eventType == 12;
        }

        @Override
        public boolean isIgnorableWhiteSpace() {
            return this.eventType == 6;
        }

        @Override
        public boolean isWhiteSpace() {
            return this.whitespace;
        }

        @Override
        void writeAsEncodedUnicodeInternal(Writer writer) throws IOException {
            if (this.isCData()) {
                writer.write("<![CDATA[");
                writer.write(this.data);
                writer.write("]]>");
            } else if (!this.isIgnorableWhiteSpace()) {
                block5: for (int i = 0; i < this.data.length(); ++i) {
                    char c = this.data.charAt(i);
                    switch (c) {
                        case '<': {
                            writer.write("&lt;");
                            continue block5;
                        }
                        case '>': {
                            writer.write("&gt;");
                            continue block5;
                        }
                        case '&': {
                            writer.write("&amp;");
                            continue block5;
                        }
                        default: {
                            writer.write(c);
                        }
                    }
                }
            }
        }
    }

    static class AttributeEvent
    extends AbstractXMLEvent
    implements Attribute {
        final QName name;
        final String value;
        final boolean specified;

        AttributeEvent(Location location, QName name, String value, boolean specified) {
            this(10, location, name, value, specified);
        }

        AttributeEvent(int eventType, Location location, QName name, String value, boolean specified) {
            super(eventType, location);
            assert (eventType == 10 || eventType == 13);
            this.name = name;
            this.value = value;
            this.specified = specified;
        }

        @Override
        public String getDTDType() {
            return "CDATA";
        }

        @Override
        public QName getName() {
            return this.name;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        @Override
        public boolean isSpecified() {
            return this.specified;
        }

        @Override
        void writeAsEncodedUnicodeInternal(Writer writer) throws IOException {
            if (!"".equals(this.name.getPrefix())) {
                writer.write(this.name.getPrefix());
                writer.write(58);
            }
            writer.write(this.name.getLocalPart());
            writer.write(61);
            writer.write(34);
            block6: for (int i = 0; i < this.value.length(); ++i) {
                char c = this.value.charAt(i);
                switch (c) {
                    case '<': {
                        writer.write("&lt;");
                        continue block6;
                    }
                    case '>': {
                        writer.write("&gt;");
                        continue block6;
                    }
                    case '&': {
                        writer.write("&amp;");
                        continue block6;
                    }
                    case '\"': {
                        writer.write("&quot;");
                        continue block6;
                    }
                    default: {
                        writer.write(c);
                    }
                }
            }
            writer.write(34);
        }
    }

    static abstract class AbstractXMLEvent
    implements XMLEvent {
        final int eventType;
        final Location location;

        static <E> List<E> toList(Iterator<E> iterator) {
            if (iterator == null || !iterator.hasNext()) {
                return Collections.emptyList();
            }
            ArrayList<E> list = new ArrayList<E>();
            while (iterator.hasNext()) {
                list.add(iterator.next());
            }
            return list;
        }

        AbstractXMLEvent(int eventType, Location location) {
            this.eventType = eventType;
            this.location = location;
        }

        @Override
        public Characters asCharacters() {
            return (Characters)((Object)this);
        }

        @Override
        public StartElement asStartElement() {
            return (StartElement)((Object)this);
        }

        @Override
        public EndElement asEndElement() {
            return (EndElement)((Object)this);
        }

        @Override
        public int getEventType() {
            return this.eventType;
        }

        @Override
        public Location getLocation() {
            return this.location;
        }

        @Override
        public QName getSchemaType() {
            return null;
        }

        @Override
        public boolean isAttribute() {
            return this.eventType == 10;
        }

        @Override
        public boolean isCharacters() {
            return this.eventType == 4 || this.eventType == 12;
        }

        @Override
        public boolean isEndDocument() {
            return this.eventType == 8;
        }

        @Override
        public boolean isEndElement() {
            return this.eventType == 2;
        }

        @Override
        public boolean isEntityReference() {
            return this.eventType == 9;
        }

        @Override
        public boolean isNamespace() {
            return this.eventType == 13;
        }

        @Override
        public boolean isProcessingInstruction() {
            return this.eventType == 3;
        }

        @Override
        public boolean isStartDocument() {
            return this.eventType == 7;
        }

        @Override
        public boolean isStartElement() {
            return this.eventType == 1;
        }

        public String toString() {
            try {
                StringWriter writer = new StringWriter();
                ((Writer)writer).write(this.getClass().getSimpleName());
                ((Writer)writer).write(40);
                this.writeAsEncodedUnicodeInternal(writer);
                ((Writer)writer).write(41);
                return ((Object)writer).toString();
            }
            catch (IOException e) {
                return super.toString();
            }
        }

        @Override
        public void writeAsEncodedUnicode(Writer writer) throws XMLStreamException {
            try {
                this.writeAsEncodedUnicodeInternal(writer);
            }
            catch (IOException e) {
                throw new XMLStreamException(e);
            }
        }

        abstract void writeAsEncodedUnicodeInternal(Writer var1) throws IOException;
    }
}

