/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.protobuf.deserializers;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.Descriptors;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.stdlib.protobuf.exceptions.AnnotationUnavailableException;
import io.ballerina.stdlib.protobuf.messages.BMessage;
import java.io.IOException;

public abstract class AbstractDeserializer {
    protected CodedInputStream input;
    protected Descriptors.FieldDescriptor fieldDescriptor;
    protected BMessage bMessage;
    protected Type messageType;
    protected Type targetType;
    protected boolean isPacked = false;

    public AbstractDeserializer(CodedInputStream input, Descriptors.FieldDescriptor fieldDescriptor, BMessage bMessage, Type targetType) {
        this.bMessage = bMessage;
        this.fieldDescriptor = fieldDescriptor;
        this.input = input;
        this.targetType = targetType;
    }

    public AbstractDeserializer(CodedInputStream input, Descriptors.FieldDescriptor fieldDescriptor, BMessage bMessage, Type targetType, boolean isPacked) {
        this.bMessage = bMessage;
        this.fieldDescriptor = fieldDescriptor;
        this.input = input;
        this.isPacked = isPacked;
        this.targetType = targetType;
    }

    public AbstractDeserializer(CodedInputStream input, Descriptors.FieldDescriptor fieldDescriptor, BMessage bMessage, Type targetType, Type messageType) {
        this.bMessage = bMessage;
        this.fieldDescriptor = fieldDescriptor;
        this.input = input;
        this.messageType = messageType;
        this.targetType = targetType;
    }

    public boolean isBMap() {
        return this.bMessage.getContent() instanceof BMap;
    }

    public boolean isBArray() {
        return this.bMessage.getContent() instanceof BArray;
    }

    public abstract void deserialize() throws IOException, Descriptors.DescriptorValidationException, AnnotationUnavailableException;
}

