/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.protobuf.deserializers;

import com.google.protobuf.CodedInputStream;
import com.google.protobuf.Descriptors;
import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.Type;
import io.ballerina.runtime.api.utils.StringUtils;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BDecimal;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.runtime.api.values.BString;
import io.ballerina.stdlib.protobuf.deserializers.AbstractDeserializer;
import io.ballerina.stdlib.protobuf.messages.BMessage;
import io.ballerina.stdlib.protobuf.nativeimpl.ProtobufConstants;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;

public class Int32Deserializer
extends AbstractDeserializer {
    public Int32Deserializer(CodedInputStream input, Descriptors.FieldDescriptor fieldDescriptor, BMessage bMessage, Type targetType, boolean isPacked) {
        super(input, fieldDescriptor, bMessage, targetType, isPacked);
    }

    @Override
    public void deserialize() throws IOException {
        BString bFieldName = StringUtils.fromString((String)this.fieldDescriptor.getName());
        if (this.isBMap()) {
            BMap bMap = (BMap)this.bMessage.getContent();
            if (this.fieldDescriptor.isRepeated()) {
                BArray int32Array = (BArray)bMap.get((Object)bFieldName);
                if (this.isPacked) {
                    while (this.input.getBytesUntilLimit() > 0) {
                        int32Array.add((long)int32Array.size(), this.readContent());
                    }
                } else {
                    int32Array.add((long)int32Array.size(), this.readContent());
                }
            } else if (this.fieldDescriptor.getContainingOneof() != null) {
                bMap.put((Object)StringUtils.fromString((String)this.fieldDescriptor.getName()), (Object)this.readContent());
            } else {
                bMap.put((Object)bFieldName, (Object)this.readContent());
            }
        } else if (this.isBArray() && this.fieldDescriptor.getFullName().equals("google.protobuf.Timestamp.nanos")) {
            BArray bArray = (BArray)this.bMessage.getContent();
            BigDecimal nanos = new BigDecimal(this.readContent()).divide(ProtobufConstants.ANALOG_GIGA, MathContext.DECIMAL128);
            bArray.add(1L, (Object)ValueCreator.createDecimalValue((BigDecimal)nanos));
        } else if (this.bMessage.getContent() instanceof BDecimal && this.fieldDescriptor.getFullName().equals("google.protobuf.Duration.nanos")) {
            BigDecimal nanos = new BigDecimal(this.readContent()).divide(ProtobufConstants.ANALOG_GIGA, MathContext.DECIMAL128);
            BigDecimal secondsValue = ((BDecimal)this.bMessage.getContent()).value();
            this.bMessage.setContent(ValueCreator.createDecimalValue((BigDecimal)secondsValue.add(nanos)));
        } else {
            this.bMessage.setContent(this.readContent());
        }
    }

    private long readContent() throws IOException {
        return this.input.readInt32();
    }
}

