/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.protobuf.serializers;

import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BMap;
import io.ballerina.stdlib.protobuf.messages.BMessage;
import io.ballerina.stdlib.protobuf.serializers.AbstractSerializer;
import java.io.IOException;

public class BooleanSerializer
extends AbstractSerializer {
    public BooleanSerializer(CodedOutputStream output, Descriptors.FieldDescriptor fieldDescriptor, BMessage bMessage) {
        super(output, fieldDescriptor, bMessage);
    }

    @Override
    public void computeMessageSize() {
        if (this.isBMap()) {
            BMap bMap = (BMap)this.bMessage.getContent();
            if (bMap.containsKey((Object)this.bFieldName)) {
                Object bValue = bMap.get((Object)this.bFieldName);
                if (bValue instanceof BArray) {
                    BArray valueArray = (BArray)bValue;
                    for (int i = 0; i < valueArray.size(); ++i) {
                        this.bMessage.incrementSize(this.computeMessageSize(valueArray.getBoolean((long)i)));
                    }
                } else {
                    this.bMessage.incrementSize(this.computeMessageSize((Boolean)bValue));
                }
            }
        } else if (this.bMessage.getContent() instanceof Boolean) {
            this.bMessage.incrementSize(this.computeMessageSize((Boolean)this.bMessage.getContent()));
        }
    }

    @Override
    public void serialize() throws IOException {
        if (this.isBMap()) {
            BMap bMap = (BMap)this.bMessage.getContent();
            if (bMap.containsKey((Object)this.bFieldName)) {
                Object bValue = bMap.get((Object)this.bFieldName);
                if (bValue instanceof BArray) {
                    BArray valueArray = (BArray)bValue;
                    for (int i = 0; i < valueArray.size(); ++i) {
                        this.writeContent(valueArray.getBoolean((long)i));
                    }
                } else {
                    this.writeContent((Boolean)bValue);
                }
            }
        } else if (this.bMessage.getContent() instanceof Boolean) {
            this.writeContent((Boolean)this.bMessage.getContent());
        }
    }

    private int computeMessageSize(boolean value) {
        return CodedOutputStream.computeBoolSize((int)this.fieldDescriptor.getNumber(), (boolean)value);
    }

    private void writeContent(boolean content) throws IOException {
        this.output.writeBool(this.fieldDescriptor.getNumber(), content);
    }
}

