/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.sql.compiler;

import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.sql.compiler.SQLDiagnosticsCodes;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.DiagnosticSeverity;

public class Utils {
    private Utils() {
    }

    public static boolean hasCompilationErrors(SyntaxNodeAnalysisContext ctx) {
        for (Diagnostic diagnostic : ctx.compilation().diagnosticResult().diagnostics()) {
            if (diagnostic.diagnosticInfo().severity() != DiagnosticSeverity.ERROR) continue;
            return true;
        }
        return false;
    }

    public static DiagnosticInfo addDiagnosticsForInvalidTypes(String outParameterName, TypeSymbol argumentTypeSymbol) {
        int sqlTypeValue;
        TypeDescKind requestedReturnType = argumentTypeSymbol.typeKind();
        String requestedReturnTypeArgValue = "";
        if (requestedReturnType == TypeDescKind.TYPE_REFERENCE) {
            TypeSymbol typeDescriptor = ((TypeReferenceTypeSymbol)argumentTypeSymbol).typeDescriptor();
            requestedReturnType = typeDescriptor.typeKind();
            requestedReturnTypeArgValue = argumentTypeSymbol.signature();
        }
        switch (outParameterName) {
            case "VarcharOutParameter": 
            case "TextOutParameter": {
                sqlTypeValue = 12;
                break;
            }
            case "CharOutParameter": {
                sqlTypeValue = 1;
                break;
            }
            case "NCharOutParameter": {
                sqlTypeValue = -15;
                break;
            }
            case "NVarcharOutParameter": {
                sqlTypeValue = -9;
                break;
            }
            case "BitOutParameter": {
                sqlTypeValue = -7;
                break;
            }
            case "BooleanOutParameter": {
                sqlTypeValue = 16;
                break;
            }
            case "IntegerOutParameter": {
                sqlTypeValue = 4;
                break;
            }
            case "BigIntOutParameter": {
                sqlTypeValue = -5;
                break;
            }
            case "SmallIntOutParameter": {
                sqlTypeValue = 5;
                break;
            }
            case "FloatOutParameter": {
                sqlTypeValue = 6;
                break;
            }
            case "RealOutParameter": {
                sqlTypeValue = 7;
                break;
            }
            case "DoubleOutParameter": {
                sqlTypeValue = 8;
                break;
            }
            case "NumericOutParameter": {
                sqlTypeValue = 2;
                break;
            }
            case "DecimalOutParameter": {
                sqlTypeValue = 3;
                break;
            }
            case "BinaryOutParameter": {
                sqlTypeValue = -2;
                break;
            }
            case "VarBinaryOutParameter": {
                sqlTypeValue = -3;
                break;
            }
            case "BlobOutParameter": {
                if (requestedReturnType == TypeDescKind.ARRAY) {
                    sqlTypeValue = -3;
                    break;
                }
                sqlTypeValue = -4;
                break;
            }
            case "ClobOutParameter": 
            case "NClobOutParameter": {
                if (requestedReturnType == TypeDescKind.STRING) {
                    sqlTypeValue = 2005;
                    break;
                }
                sqlTypeValue = -1;
                break;
            }
            case "DateOutParameter": {
                sqlTypeValue = 91;
                break;
            }
            case "TimeOutParameter": {
                sqlTypeValue = 92;
                break;
            }
            case "TimeWithTimezoneOutParameter": {
                sqlTypeValue = 2013;
                break;
            }
            case "TimestampOutParameter": 
            case "DateTimeOutParameter": {
                sqlTypeValue = 93;
                break;
            }
            case "TimestampWithTimezoneOutParameter": {
                sqlTypeValue = 2014;
                break;
            }
            case "ArrayOutParameter": 
            case "SmallIntArrayOutParameter": 
            case "BigIntArrayOutParameter": 
            case "BinaryArrayOutParameter": 
            case "BitArrayOutParameter": 
            case "BooleanArrayOutParameter": 
            case "CharArrayOutParameter": 
            case "DateArrayOutParameter": 
            case "DateTimeArrayOutParameter": 
            case "DecimalArrayOutParameter": 
            case "DoubleArrayOutParameter": 
            case "FloatArrayOutParameter": 
            case "IntegerArrayOutParameter": 
            case "NumericArrayOutParameter": 
            case "NVarcharArrayOutParameter": 
            case "TimeWithTimezoneArrayOutParameter": 
            case "TimestampWithTimezoneArrayOutParameter": 
            case "TimestampArrayOutParameter": 
            case "RealArrayOutParameter": 
            case "VarBinaryArrayOutParameter": 
            case "VarcharArrayOutParameter": 
            case "TimeArrayOutParameter": {
                sqlTypeValue = 2003;
                break;
            }
            case "RefOutParameter": {
                sqlTypeValue = 2006;
                break;
            }
            case "StructOutParameter": {
                sqlTypeValue = 2002;
                break;
            }
            case "RowOutParameter": {
                sqlTypeValue = -8;
                break;
            }
            case "XMLOutParameter": {
                sqlTypeValue = 2009;
                break;
            }
            default: {
                return null;
            }
        }
        switch (sqlTypeValue) {
            case -15: 
            case -9: 
            case -1: 
            case 1: 
            case 12: 
            case 2005: {
                if (requestedReturnType == TypeDescKind.STRING || requestedReturnType == TypeDescKind.JSON) {
                    return null;
                }
                return new DiagnosticInfo(SQLDiagnosticsCodes.SQL_211.getCode(), SQLDiagnosticsCodes.SQL_211.getMessage(), SQLDiagnosticsCodes.SQL_211.getSeverity());
            }
            case -4: 
            case -3: 
            case -2: {
                if (requestedReturnType == TypeDescKind.ARRAY || requestedReturnType == TypeDescKind.STRING) {
                    return null;
                }
                return new DiagnosticInfo(SQLDiagnosticsCodes.SQL_212.getCode(), SQLDiagnosticsCodes.SQL_212.getMessage(), SQLDiagnosticsCodes.SQL_212.getSeverity());
            }
            case 2003: {
                if (requestedReturnType == TypeDescKind.ARRAY) {
                    return null;
                }
                return new DiagnosticInfo(SQLDiagnosticsCodes.SQL_201.getCode(), SQLDiagnosticsCodes.SQL_201.getMessage(), SQLDiagnosticsCodes.SQL_201.getSeverity());
            }
            case 91: {
                if (requestedReturnType == TypeDescKind.RECORD && requestedReturnTypeArgValue.startsWith("ballerina/time") && requestedReturnTypeArgValue.endsWith("Date") || requestedReturnType == TypeDescKind.INT || requestedReturnType == TypeDescKind.STRING) {
                    return null;
                }
                return new DiagnosticInfo(SQLDiagnosticsCodes.SQL_222.getCode(), SQLDiagnosticsCodes.SQL_222.getMessage(), SQLDiagnosticsCodes.SQL_222.getSeverity());
            }
            case 92: 
            case 2013: {
                if (requestedReturnType == TypeDescKind.RECORD && requestedReturnTypeArgValue.startsWith("ballerina/time") && requestedReturnTypeArgValue.endsWith("TimeOfDay") || requestedReturnType == TypeDescKind.INT || requestedReturnType == TypeDescKind.STRING) {
                    return null;
                }
                return new DiagnosticInfo(SQLDiagnosticsCodes.SQL_223.getCode(), SQLDiagnosticsCodes.SQL_223.getMessage(), SQLDiagnosticsCodes.SQL_223.getSeverity());
            }
            case 93: 
            case 2014: {
                if (requestedReturnType == TypeDescKind.RECORD && requestedReturnTypeArgValue.startsWith("ballerina/time") && requestedReturnTypeArgValue.endsWith("Civil") || requestedReturnType == TypeDescKind.INTERSECTION && requestedReturnTypeArgValue.startsWith("ballerina/time") && requestedReturnTypeArgValue.endsWith("Utc") || requestedReturnType == TypeDescKind.INT || requestedReturnType == TypeDescKind.STRING) {
                    return null;
                }
                return new DiagnosticInfo(SQLDiagnosticsCodes.SQL_231.getCode(), SQLDiagnosticsCodes.SQL_231.getMessage(), SQLDiagnosticsCodes.SQL_231.getSeverity());
            }
            case -8: {
                if (requestedReturnType == TypeDescKind.ARRAY) {
                    return null;
                }
                return new DiagnosticInfo(SQLDiagnosticsCodes.SQL_204.getCode(), SQLDiagnosticsCodes.SQL_204.getMessage(), SQLDiagnosticsCodes.SQL_204.getSeverity());
            }
            case -5: 
            case 4: 
            case 5: {
                if (requestedReturnType == TypeDescKind.INT || requestedReturnType == TypeDescKind.STRING) {
                    return null;
                }
                return new DiagnosticInfo(SQLDiagnosticsCodes.SQL_213.getCode(), SQLDiagnosticsCodes.SQL_213.getMessage(), SQLDiagnosticsCodes.SQL_213.getSeverity());
            }
            case 6: 
            case 7: 
            case 8: {
                if (requestedReturnType == TypeDescKind.FLOAT || requestedReturnType == TypeDescKind.STRING) {
                    return null;
                }
                return new DiagnosticInfo(SQLDiagnosticsCodes.SQL_214.getCode(), SQLDiagnosticsCodes.SQL_214.getMessage(), SQLDiagnosticsCodes.SQL_214.getSeverity());
            }
            case 2: 
            case 3: {
                if (requestedReturnType == TypeDescKind.DECIMAL || requestedReturnType == TypeDescKind.STRING) {
                    return null;
                }
                return new DiagnosticInfo(SQLDiagnosticsCodes.SQL_215.getCode(), SQLDiagnosticsCodes.SQL_215.getMessage(), SQLDiagnosticsCodes.SQL_215.getSeverity());
            }
            case -7: 
            case 16: {
                if (requestedReturnType == TypeDescKind.BOOLEAN || requestedReturnType == TypeDescKind.INT || requestedReturnType == TypeDescKind.STRING) {
                    return null;
                }
                return new DiagnosticInfo(SQLDiagnosticsCodes.SQL_221.getCode(), SQLDiagnosticsCodes.SQL_221.getMessage(), SQLDiagnosticsCodes.SQL_221.getSeverity());
            }
            case 2002: 
            case 2006: {
                if (requestedReturnType == TypeDescKind.RECORD) {
                    return null;
                }
                return new DiagnosticInfo(SQLDiagnosticsCodes.SQL_202.getCode(), SQLDiagnosticsCodes.SQL_202.getMessage(), SQLDiagnosticsCodes.SQL_202.getSeverity());
            }
            case 2009: {
                if (requestedReturnType == TypeDescKind.XML) {
                    return null;
                }
                return new DiagnosticInfo(SQLDiagnosticsCodes.SQL_203.getCode(), SQLDiagnosticsCodes.SQL_203.getMessage(), SQLDiagnosticsCodes.SQL_203.getSeverity());
            }
        }
        return null;
    }
}

