/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.stdlib.sql.compiler.analyzer;

import io.ballerina.compiler.api.symbols.ModuleSymbol;
import io.ballerina.compiler.api.symbols.Symbol;
import io.ballerina.compiler.api.symbols.TypeDescKind;
import io.ballerina.compiler.api.symbols.TypeReferenceTypeSymbol;
import io.ballerina.compiler.api.symbols.TypeSymbol;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionArgumentNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.projects.plugins.AnalysisTask;
import io.ballerina.projects.plugins.SyntaxNodeAnalysisContext;
import io.ballerina.stdlib.sql.compiler.Utils;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.Location;
import java.util.Optional;

public class MethodAnalyzer
implements AnalysisTask<SyntaxNodeAnalysisContext> {
    public void perform(SyntaxNodeAnalysisContext ctx) {
        MethodCallExpressionNode node = (MethodCallExpressionNode)ctx.node();
        if (Utils.hasCompilationErrors(ctx)) {
            return;
        }
        ExpressionNode methodExpression = node.expression();
        Optional methodExpReferenceType = ctx.semanticModel().typeOf((Node)methodExpression);
        if (methodExpReferenceType.isEmpty()) {
            return;
        }
        if (((TypeSymbol)methodExpReferenceType.get()).typeKind() != TypeDescKind.TYPE_REFERENCE) {
            return;
        }
        TypeReferenceTypeSymbol methodExpTypeSymbol = (TypeReferenceTypeSymbol)methodExpReferenceType.get();
        Optional optionalModuleSymbol = methodExpTypeSymbol.getModule();
        if (optionalModuleSymbol.isEmpty()) {
            return;
        }
        ModuleSymbol module = (ModuleSymbol)optionalModuleSymbol.get();
        if (!module.id().orgName().equals("ballerina") || !module.id().moduleName().equals("sql")) {
            return;
        }
        String objectName = (String)((TypeReferenceTypeSymbol)methodExpReferenceType.get()).definition().getName().get();
        if (this.isGetMethod(ctx, node)) {
            return;
        }
        SeparatedNodeList arguments = node.arguments();
        if (arguments.size() != 1) {
            return;
        }
        Optional typeDescriptionArgument = ctx.semanticModel().symbol(node.arguments().get(0));
        if (typeDescriptionArgument.isEmpty()) {
            return;
        }
        TypeSymbol argumentTypeSymbol = (TypeSymbol)typeDescriptionArgument.get();
        DiagnosticInfo diagnosticsForInvalidTypes = Utils.addDiagnosticsForInvalidTypes(objectName, argumentTypeSymbol);
        if (diagnosticsForInvalidTypes != null) {
            ctx.reportDiagnostic(DiagnosticFactory.createDiagnostic((DiagnosticInfo)diagnosticsForInvalidTypes, (Location)((FunctionArgumentNode)node.arguments().get(0)).location(), (Object[])new Object[0]));
        }
    }

    private boolean isGetMethod(SyntaxNodeAnalysisContext ctx, MethodCallExpressionNode node) {
        Optional methodSymbol = ctx.semanticModel().symbol((Node)node.methodName());
        if (methodSymbol.isEmpty()) {
            return true;
        }
        Optional methodName = ((Symbol)methodSymbol.get()).getName();
        if (methodName.isEmpty()) {
            return true;
        }
        return !((String)methodName.get()).equals("get");
    }
}

