/*
 * Decompiled with CFR 0.152.
 */
package org.ballerinalang.langlib.regexp;

import io.ballerina.runtime.api.creators.ValueCreator;
import io.ballerina.runtime.api.types.ArrayType;
import io.ballerina.runtime.api.values.BArray;
import io.ballerina.runtime.api.values.BRegexpValue;
import io.ballerina.runtime.api.values.BString;
import java.util.regex.Matcher;
import org.ballerinalang.langlib.regexp.RegexUtil;

public final class Find {
    private Find() {
    }

    public static BArray find(BRegexpValue regExp, BString str, long startIndex) {
        RegexUtil.checkIndexWithinRange(str, startIndex);
        int[] surrogates = RegexUtil.getSurrogatePositions(str);
        int adjustedStartIndex = RegexUtil.getSurrogateAdjustedStartIndex((int)startIndex, surrogates);
        Matcher matcher = RegexUtil.getMatcher(regExp, str);
        if (matcher.find(adjustedStartIndex)) {
            return RegexUtil.getGroupZeroAsSpan(str, matcher, surrogates);
        }
        return null;
    }

    public static BArray findGroups(BRegexpValue regExp, BString str, long startIndex) {
        RegexUtil.checkIndexWithinRange(str, startIndex);
        int[] surrogates = RegexUtil.getSurrogatePositions(str);
        int adjustedStartIndex = RegexUtil.getSurrogateAdjustedStartIndex((int)startIndex, surrogates);
        Matcher matcher = RegexUtil.getMatcher(regExp, str);
        BArray resultArray = ValueCreator.createArrayValue((ArrayType)RegexUtil.GROUPS_AS_SPAN_ARRAY_TYPE);
        matcher.region(adjustedStartIndex, str.getValue().length());
        if (matcher.find()) {
            if (matcher.groupCount() != 0) {
                BArray spanArr = RegexUtil.getMatcherGroupsAsSpanArr(str, matcher, surrogates);
                int i = 0;
                while ((long)i < spanArr.getLength()) {
                    resultArray.append(spanArr.get((long)i));
                    ++i;
                }
            } else {
                resultArray.append((Object)RegexUtil.getGroupZeroAsSpan(str, matcher, surrogates));
            }
        }
        if (resultArray.getLength() == 0L) {
            return null;
        }
        return resultArray;
    }

    public static BArray findAll(BRegexpValue regExp, BString str, long startIndex) {
        RegexUtil.checkIndexWithinRange(str, startIndex);
        Matcher matcher = RegexUtil.getMatcher(regExp, str);
        int[] surrogates = RegexUtil.getSurrogatePositions(str);
        int adjustedStartIndex = RegexUtil.getSurrogateAdjustedStartIndex((int)startIndex, surrogates);
        BArray resultArray = ValueCreator.createArrayValue((ArrayType)RegexUtil.GROUPS_AS_SPAN_ARRAY_TYPE);
        matcher.region(adjustedStartIndex, str.getValue().length());
        while (matcher.find()) {
            resultArray.append((Object)RegexUtil.getGroupZeroAsSpan(str, matcher, surrogates));
        }
        if (resultArray.getLength() == 0L) {
            return null;
        }
        return resultArray;
    }

    public static BArray findAllGroups(BRegexpValue regExp, BString str, long startIndex) {
        RegexUtil.checkIndexWithinRange(str, startIndex);
        Matcher matcher = RegexUtil.getMatcher(regExp, str);
        int[] surrogates = RegexUtil.getSurrogatePositions(str);
        int adjustedStartIndex = RegexUtil.getSurrogateAdjustedStartIndex((int)startIndex, surrogates);
        matcher.region(adjustedStartIndex, str.getValue().length());
        BArray groupArray = ValueCreator.createArrayValue((ArrayType)RegexUtil.GROUPS_ARRAY_TYPE);
        while (matcher.find()) {
            BArray group = RegexUtil.getMatcherGroupsAsSpanArr(str, matcher, surrogates);
            if (group.getLength() == 0L) continue;
            groupArray.append((Object)group);
        }
        if (groupArray.getLength() == 0L) {
            return null;
        }
        return groupArray;
    }
}

