/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.graphql.generator;

import io.ballerina.graphql.generator.GraphqlProject;
import io.ballerina.graphql.generator.client.exception.ClientCodeGenerationException;
import io.ballerina.graphql.generator.service.exception.ServiceGenerationException;
import io.ballerina.graphql.generator.utils.CodeGeneratorUtils;
import io.ballerina.graphql.generator.utils.SrcFilePojo;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;

public abstract class CodeGenerator {
    public abstract void generate(GraphqlProject var1) throws ClientCodeGenerationException, ServiceGenerationException;

    protected void writeGeneratedSources(List<SrcFilePojo> sources, Path outputPath) throws IOException {
        if (!sources.isEmpty()) {
            for (SrcFilePojo file : sources) {
                if (!file.getType().isOverwritable()) continue;
                Path filePath = CodeGeneratorUtils.getAbsoluteFilePath(file, outputPath);
                String fileContent = file.getContent();
                CodeGeneratorUtils.writeFile(filePath, fileContent);
            }
        }
    }
}

