/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.graphql.generator.client.generator.ballerina;

import graphql.schema.GraphQLSchema;
import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.AssignmentStatementNode;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.BlockStatementNode;
import io.ballerina.compiler.syntax.tree.BuiltinSimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.CaptureBindingPatternNode;
import io.ballerina.compiler.syntax.tree.CheckExpressionNode;
import io.ballerina.compiler.syntax.tree.DoStatementNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FieldAccessExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FunctionCallExpressionNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.MappingConstructorExpressionNode;
import io.ballerina.compiler.syntax.tree.MethodCallExpressionNode;
import io.ballerina.compiler.syntax.tree.NameReferenceNode;
import io.ballerina.compiler.syntax.tree.NamedArgumentNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.NodeParser;
import io.ballerina.compiler.syntax.tree.OnFailClauseNode;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.RemoteMethodCallActionNode;
import io.ballerina.compiler.syntax.tree.RequiredExpressionNode;
import io.ballerina.compiler.syntax.tree.ReturnStatementNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SpecificFieldNode;
import io.ballerina.compiler.syntax.tree.StatementNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.TemplateExpressionNode;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypeReferenceTypeDescNode;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.compiler.syntax.tree.VariableDeclarationNode;
import io.ballerina.graphql.generator.client.generator.graphql.components.ExtendedOperationDefinition;
import io.ballerina.graphql.generator.client.generator.model.AuthConfig;
import io.ballerina.graphql.generator.utils.CodeGeneratorUtils;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FunctionBodyGenerator {
    private static FunctionBodyGenerator functionBodyGenerator = null;

    public static FunctionBodyGenerator getInstance() {
        if (functionBodyGenerator == null) {
            functionBodyGenerator = new FunctionBodyGenerator();
        }
        return functionBodyGenerator;
    }

    public FunctionBodyNode generateInitFunctionBody(AuthConfig authConfig) {
        ArrayList<Object> assignmentNodes = new ArrayList<Object>();
        List<StatementNode> httpClientConfigNode = this.generateHttpClientConfigurationNode(authConfig);
        VariableDeclarationNode clientInitializationNode = this.generateClientInitializationNode();
        FieldAccessExpressionNode varRef = NodeFactory.createFieldAccessExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"self")), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.DOT_TOKEN), (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"graphqlClient")));
        SimpleNameReferenceNode expr = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"clientEp"));
        AssignmentStatementNode httpClientAssignmentStatementNode = NodeFactory.createAssignmentStatementNode((Node)varRef, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)expr, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        AssignmentStatementNode apiKeyConfigAssignmentStatementNode = this.generateApiKeyConfigAssignmentStatementNode();
        assignmentNodes.addAll(httpClientConfigNode);
        assignmentNodes.add(clientInitializationNode);
        assignmentNodes.add(httpClientAssignmentStatementNode);
        if (authConfig.isApiKeysConfig()) {
            assignmentNodes.add(apiKeyConfigAssignmentStatementNode);
        }
        NodeList statementList = AbstractNodeFactory.createNodeList(assignmentNodes);
        return NodeFactory.createFunctionBodyBlockNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), null, (NodeList)statementList, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN), null);
    }

    private List<StatementNode> generateHttpClientConfigurationNode(AuthConfig authConfig) {
        ArrayList<StatementNode> assignmentNodes = new ArrayList<StatementNode>();
        NodeList annotationNodes = NodeFactory.createEmptyNodeList();
        BuiltinSimpleNameReferenceNode typeBindingPattern = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)"graphql:ClientConfiguration"));
        CaptureBindingPatternNode bindingPattern = NodeFactory.createCaptureBindingPatternNode((Token)AbstractNodeFactory.createIdentifierToken((String)"graphqlClientConfig"));
        TypedBindingPatternNode typedBindingPatternNode = NodeFactory.createTypedBindingPatternNode((TypeDescriptorNode)typeBindingPattern, (BindingPatternNode)bindingPattern);
        ArrayList<Object> defaultFields = new ArrayList<Object>();
        int count = 0;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        if (authConfig.isClientConfig()) {
            map.put("auth", "config.auth");
        }
        map.put("timeout", "config.timeout");
        map.put("forwarded", "config.forwarded");
        map.put("poolConfig", "config.poolConfig");
        map.put("compression", "config.compression");
        map.put("circuitBreaker", "config.circuitBreaker");
        map.put("retryConfig", "config.retryConfig");
        map.put("validation", "config.validation");
        for (Map.Entry entry : map.entrySet()) {
            BuiltinSimpleNameReferenceNode valueExpr = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)((String)entry.getValue())));
            SpecificFieldNode specificFieldNode = NodeFactory.createSpecificFieldNode(null, (Node)AbstractNodeFactory.createIdentifierToken((String)((String)entry.getKey())), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (ExpressionNode)valueExpr);
            defaultFields.add(specificFieldNode);
            if (++count >= map.size()) continue;
            defaultFields.add(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
        }
        MappingConstructorExpressionNode initializer = NodeFactory.createMappingConstructorExpressionNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (SeparatedNodeList)NodeFactory.createSeparatedNodeList(defaultFields), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
        assignmentNodes.add((StatementNode)NodeFactory.createVariableDeclarationNode((NodeList)annotationNodes, null, (TypedBindingPatternNode)typedBindingPatternNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)initializer, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN)));
        DoStatementNode doStatementNode = this.generateHttpClientConfigOptionalFieldsAssignment();
        assignmentNodes.add((StatementNode)doStatementNode);
        return assignmentNodes;
    }

    private DoStatementNode generateHttpClientConfigOptionalFieldsAssignment() {
        ArrayList<StatementNode> nodes = new ArrayList<StatementNode>();
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("cache", "CacheConfig");
        map.put("responseLimits", "ResponseLimitConfigs");
        map.put("secureSocket", "ClientSecureSocket");
        map.put("proxy", "ProxyConfig");
        String http1SettingsStatement = "if config.http1Settings is ClientHttp1Settings {\n        ClientHttp1Settings settings = check config.http1Settings.ensureType(ClientHttp1Settings);\n        graphqlClientConfig.http1Settings = {...settings};    }";
        nodes.add(NodeParser.parseStatement((String)http1SettingsStatement));
        for (Map.Entry entry : map.entrySet()) {
            String node = String.format("if config.%s is graphql:%s {\n        graphqlClientConfig.%s = check config.%s.ensureType(graphql:%s);\n    }\n", entry.getKey(), entry.getValue(), entry.getKey(), entry.getKey(), entry.getValue());
            nodes.add(NodeParser.parseStatement((String)node));
        }
        BlockStatementNode doBlockStatementNode = NodeFactory.createBlockStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (NodeList)AbstractNodeFactory.createNodeList(nodes), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
        TypeReferenceTypeDescNode varNode = NodeFactory.createTypeReferenceTypeDescNode((NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.VAR_KEYWORD)));
        IdentifierToken errorParamName = AbstractNodeFactory.createIdentifierToken((String)"e");
        ExpressionNode errorNode = NodeParser.parseExpression((String)"<graphql:ClientError> error(\"GraphQL Client Error\", e, body = ())");
        ReturnStatementNode returnStatementNode = NodeFactory.createReturnStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RETURN_KEYWORD), (ExpressionNode)errorNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
        NodeList failNodeList = AbstractNodeFactory.createNodeList((Node[])new StatementNode[]{returnStatementNode});
        BlockStatementNode failBlockStatementNode = NodeFactory.createBlockStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (NodeList)failNodeList, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
        OnFailClauseNode onFailClauseNode = NodeFactory.createOnFailClauseNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ON_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.FAIL_KEYWORD), (TypeDescriptorNode)varNode, (IdentifierToken)errorParamName, (BlockStatementNode)failBlockStatementNode);
        return NodeFactory.createDoStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.DO_KEYWORD), (BlockStatementNode)doBlockStatementNode, (OnFailClauseNode)onFailClauseNode);
    }

    public FunctionBodyNode generateRemoteFunctionBody(ExtendedOperationDefinition queryDefinition, GraphQLSchema graphQLSchema, AuthConfig authConfig) {
        ArrayList<Object> assignmentNodes = new ArrayList<Object>();
        VariableDeclarationNode queryVariableDeclarationNode = this.generateQueryVariableDeclarationNode(queryDefinition);
        VariableDeclarationNode graphqlVariablesDeclarationNode = this.getGraphqlVariablesDeclarationNode(queryDefinition, graphQLSchema);
        VariableDeclarationNode headerValuesVariableDeclarationNode = this.generateHeaderValuesVariableDeclarationNode(authConfig);
        VariableDeclarationNode httpHeadersVariableDeclarationNode = this.generateHttpHeadersVariableDeclarationNode();
        assignmentNodes.add(queryVariableDeclarationNode);
        assignmentNodes.add(graphqlVariablesDeclarationNode);
        if (authConfig.isApiKeysConfig()) {
            assignmentNodes.add(headerValuesVariableDeclarationNode);
            assignmentNodes.add(httpHeadersVariableDeclarationNode);
            assignmentNodes.add(this.generateGraphqlResponseVariableDeclarationNodeWithHttpHeaders(queryDefinition));
        } else {
            assignmentNodes.add(this.generateGraphqlResponseVariableDeclarationNode(queryDefinition));
        }
        assignmentNodes.add(this.generateReturnStatementNode(queryDefinition));
        NodeList statementList = AbstractNodeFactory.createNodeList(assignmentNodes);
        return NodeFactory.createFunctionBodyBlockNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), null, (NodeList)statementList, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN), null);
    }

    private VariableDeclarationNode generateClientInitializationNode() {
        NodeList annotationNodes = NodeFactory.createEmptyNodeList();
        BuiltinSimpleNameReferenceNode typeBindingPattern = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)"graphql:Client"));
        CaptureBindingPatternNode bindingPattern = NodeFactory.createCaptureBindingPatternNode((Token)AbstractNodeFactory.createIdentifierToken((String)"clientEp"));
        TypedBindingPatternNode typedBindingPatternNode = NodeFactory.createTypedBindingPatternNode((TypeDescriptorNode)typeBindingPattern, (BindingPatternNode)bindingPattern);
        ArrayList<Object> argumentsList = new ArrayList<Object>();
        PositionalArgumentNode positionalArgumentNode01 = NodeFactory.createPositionalArgumentNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"serviceUrl")));
        argumentsList.add(positionalArgumentNode01);
        IdentifierToken comma1 = AbstractNodeFactory.createIdentifierToken((String)",");
        PositionalArgumentNode positionalArgumentNode02 = NodeFactory.createPositionalArgumentNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"graphqlClientConfig")));
        argumentsList.add(comma1);
        argumentsList.add(positionalArgumentNode02);
        SeparatedNodeList arguments = NodeFactory.createSeparatedNodeList(argumentsList);
        ParenthesizedArgList parenthesizedArgList = NodeFactory.createParenthesizedArgList((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), (SeparatedNodeList)arguments, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN));
        ImplicitNewExpressionNode expressionNode = NodeFactory.createImplicitNewExpressionNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.NEW_KEYWORD), (ParenthesizedArgList)parenthesizedArgList);
        CheckExpressionNode initializer = NodeFactory.createCheckExpressionNode(null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CHECK_KEYWORD), (ExpressionNode)expressionNode);
        return NodeFactory.createVariableDeclarationNode((NodeList)annotationNodes, null, (TypedBindingPatternNode)typedBindingPatternNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)initializer, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    private AssignmentStatementNode generateApiKeyConfigAssignmentStatementNode() {
        FieldAccessExpressionNode varRefApiKey = NodeFactory.createFieldAccessExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"self")), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.DOT_TOKEN), (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"apiKeysConfig")));
        RequiredExpressionNode fieldAccessExpressionNode = NodeFactory.createRequiredExpressionNode((Token)AbstractNodeFactory.createIdentifierToken((String)"apiKeysConfig"));
        MethodCallExpressionNode methodCallExpressionNode = NodeFactory.createMethodCallExpressionNode((ExpressionNode)fieldAccessExpressionNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.DOT_TOKEN), (NameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"cloneReadOnly")), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), (SeparatedNodeList)NodeFactory.createSeparatedNodeList((Node[])new Node[0]), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN));
        return NodeFactory.createAssignmentStatementNode((Node)varRefApiKey, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)methodCallExpressionNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    private VariableDeclarationNode generateQueryVariableDeclarationNode(ExtendedOperationDefinition queryDefinition) {
        NodeList annotationNodes = NodeFactory.createEmptyNodeList();
        BuiltinSimpleNameReferenceNode typeBindingPattern = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.STRING_KEYWORD));
        CaptureBindingPatternNode bindingPattern = NodeFactory.createCaptureBindingPatternNode((Token)AbstractNodeFactory.createIdentifierToken((String)"query"));
        TypedBindingPatternNode typedBindingPatternNode = NodeFactory.createTypedBindingPatternNode((TypeDescriptorNode)typeBindingPattern, (BindingPatternNode)bindingPattern);
        NodeList content = AbstractNodeFactory.createNodeList((Node[])new Node[]{AbstractNodeFactory.createIdentifierToken((String)queryDefinition.getQueryString())});
        TemplateExpressionNode initializer = NodeFactory.createTemplateExpressionNode(null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.STRING_KEYWORD), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.BACKTICK_TOKEN), (NodeList)content, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.BACKTICK_TOKEN));
        return NodeFactory.createVariableDeclarationNode((NodeList)annotationNodes, null, (TypedBindingPatternNode)typedBindingPatternNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)initializer, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    private VariableDeclarationNode getGraphqlVariablesDeclarationNode(ExtendedOperationDefinition queryDefinition, GraphQLSchema graphQLSchema) {
        NodeList annotationNodes = NodeFactory.createEmptyNodeList();
        BuiltinSimpleNameReferenceNode typeBindingPattern = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)"map<anydata>"));
        CaptureBindingPatternNode bindingPattern = NodeFactory.createCaptureBindingPatternNode((Token)AbstractNodeFactory.createIdentifierToken((String)"variables"));
        TypedBindingPatternNode typedBindingPatternNode = NodeFactory.createTypedBindingPatternNode((TypeDescriptorNode)typeBindingPattern, (BindingPatternNode)bindingPattern);
        ArrayList<Object> specificFields = new ArrayList<Object>();
        int count = 0;
        for (String variableName : queryDefinition.getVariableDefinitionsMap(graphQLSchema).keySet()) {
            BuiltinSimpleNameReferenceNode valueExpr = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)CodeGeneratorUtils.escapeIdentifier(variableName)));
            SpecificFieldNode specificFieldNode = NodeFactory.createSpecificFieldNode(null, (Node)AbstractNodeFactory.createIdentifierToken((String)("\"" + variableName + "\"")), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (ExpressionNode)valueExpr);
            specificFields.add(specificFieldNode);
            if (++count >= queryDefinition.getVariableDefinitionsMap(graphQLSchema).size()) continue;
            specificFields.add(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
        }
        MappingConstructorExpressionNode initializer = NodeFactory.createMappingConstructorExpressionNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (SeparatedNodeList)NodeFactory.createSeparatedNodeList(specificFields), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
        return NodeFactory.createVariableDeclarationNode((NodeList)annotationNodes, null, (TypedBindingPatternNode)typedBindingPatternNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)initializer, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    private VariableDeclarationNode generateHeaderValuesVariableDeclarationNode(AuthConfig authConfig) {
        NodeList annotationNodes = NodeFactory.createEmptyNodeList();
        BuiltinSimpleNameReferenceNode typeBindingPattern = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)"map<any>"));
        CaptureBindingPatternNode bindingPattern = NodeFactory.createCaptureBindingPatternNode((Token)AbstractNodeFactory.createIdentifierToken((String)"headerValues"));
        TypedBindingPatternNode typedBindingPatternNode = NodeFactory.createTypedBindingPatternNode((TypeDescriptorNode)typeBindingPattern, (BindingPatternNode)bindingPattern);
        Set<String> apiHeaders = authConfig.getApiHeaders();
        ArrayList<Object> specificFields = new ArrayList<Object>();
        int count = 0;
        for (String apiHeaderName : apiHeaders) {
            IdentifierToken apiKeyConfigIdentifierToken = AbstractNodeFactory.createIdentifierToken((String)"apiKeysConfig");
            SimpleNameReferenceNode apiKeyConfigParamNode = NodeFactory.createSimpleNameReferenceNode((Token)apiKeyConfigIdentifierToken);
            FieldAccessExpressionNode fieldExpr = NodeFactory.createFieldAccessExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"self")), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.DOT_TOKEN), (NameReferenceNode)apiKeyConfigParamNode);
            SimpleNameReferenceNode valueExpr = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)CodeGeneratorUtils.getValidName(apiHeaderName)));
            FieldAccessExpressionNode apiKeyExpr = NodeFactory.createFieldAccessExpressionNode((ExpressionNode)fieldExpr, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.DOT_TOKEN), (NameReferenceNode)valueExpr);
            SpecificFieldNode specificFieldNode = NodeFactory.createSpecificFieldNode(null, (Node)AbstractNodeFactory.createIdentifierToken((String)("\"" + apiHeaderName + "\"")), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (ExpressionNode)apiKeyExpr);
            specificFields.add(specificFieldNode);
            if (++count >= apiHeaders.size()) continue;
            specificFields.add(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
        }
        MappingConstructorExpressionNode initializer = NodeFactory.createMappingConstructorExpressionNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), (SeparatedNodeList)NodeFactory.createSeparatedNodeList(specificFields), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN));
        return NodeFactory.createVariableDeclarationNode((NodeList)annotationNodes, null, (TypedBindingPatternNode)typedBindingPatternNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)initializer, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    private VariableDeclarationNode generateHttpHeadersVariableDeclarationNode() {
        NodeList annotationNodes = NodeFactory.createEmptyNodeList();
        BuiltinSimpleNameReferenceNode typeBindingPattern = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createIdentifierToken((String)"map<string|string[]>"));
        CaptureBindingPatternNode bindingPattern = NodeFactory.createCaptureBindingPatternNode((Token)AbstractNodeFactory.createIdentifierToken((String)"httpHeaders"));
        TypedBindingPatternNode typedBindingPatternNode = NodeFactory.createTypedBindingPatternNode((TypeDescriptorNode)typeBindingPattern, (BindingPatternNode)bindingPattern);
        IdentifierToken functionName = AbstractNodeFactory.createIdentifierToken((String)"getMapForHeaders");
        SimpleNameReferenceNode functionNameNode = NodeFactory.createSimpleNameReferenceNode((Token)functionName);
        SimpleNameReferenceNode expressionNode = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"headerValues"));
        PositionalArgumentNode node = NodeFactory.createPositionalArgumentNode((ExpressionNode)expressionNode);
        SeparatedNodeList arguments = NodeFactory.createSeparatedNodeList((Node[])new Node[]{node});
        FunctionCallExpressionNode initializer = NodeFactory.createFunctionCallExpressionNode((NameReferenceNode)functionNameNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), (SeparatedNodeList)arguments, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN));
        return NodeFactory.createVariableDeclarationNode((NodeList)annotationNodes, null, (TypedBindingPatternNode)typedBindingPatternNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)initializer, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    private ReturnStatementNode generateReturnStatementNode(ExtendedOperationDefinition queryDefinition) {
        SimpleNameReferenceNode expr = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)CodeGeneratorUtils.getRemoteFunctionBodyReturnTypeName(queryDefinition.getName())));
        return NodeFactory.createReturnStatementNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RETURN_KEYWORD), (ExpressionNode)expr, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    private VariableDeclarationNode generateGraphqlResponseVariableDeclarationNode(ExtendedOperationDefinition queryDefinition) {
        NodeList annotationNodes = NodeFactory.createEmptyNodeList();
        BuiltinSimpleNameReferenceNode typeDescriptor = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.JSON_KEYWORD));
        CaptureBindingPatternNode bindingPattern = NodeFactory.createCaptureBindingPatternNode((Token)AbstractNodeFactory.createIdentifierToken((String)"graphqlResponse"));
        TypedBindingPatternNode typedBindingPatternNode = NodeFactory.createTypedBindingPatternNode((TypeDescriptorNode)typeDescriptor, (BindingPatternNode)bindingPattern);
        SimpleNameReferenceNode fieldName = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"graphqlClient"));
        FieldAccessExpressionNode graphqlClientFieldAccessExpr = NodeFactory.createFieldAccessExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"self")), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.DOT_TOKEN), (NameReferenceNode)fieldName);
        SimpleNameReferenceNode methodName = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"executeWithType"));
        ArrayList<Object> arguments = new ArrayList<Object>();
        PositionalArgumentNode queryArgument = NodeFactory.createPositionalArgumentNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"query")));
        PositionalArgumentNode variableSArgument = NodeFactory.createPositionalArgumentNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"variables")));
        arguments.add(queryArgument);
        arguments.add(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
        arguments.add(variableSArgument);
        SeparatedNodeList remoteFunctionArguments = NodeFactory.createSeparatedNodeList(arguments);
        RemoteMethodCallActionNode remoteMethodCallExpr = NodeFactory.createRemoteMethodCallActionNode((ExpressionNode)graphqlClientFieldAccessExpr, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RIGHT_ARROW_TOKEN), (SimpleNameReferenceNode)methodName, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), (SeparatedNodeList)remoteFunctionArguments, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN));
        CheckExpressionNode initializer = NodeFactory.createCheckExpressionNode(null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CHECK_KEYWORD), (ExpressionNode)remoteMethodCallExpr);
        return NodeFactory.createVariableDeclarationNode((NodeList)annotationNodes, null, (TypedBindingPatternNode)typedBindingPatternNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)initializer, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    private VariableDeclarationNode generateGraphqlResponseVariableDeclarationNodeWithHttpHeaders(ExtendedOperationDefinition queryDefinition) {
        NodeList annotationNodes = NodeFactory.createEmptyNodeList();
        BuiltinSimpleNameReferenceNode typeDescriptor = NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.JSON_KEYWORD));
        CaptureBindingPatternNode bindingPattern = NodeFactory.createCaptureBindingPatternNode((Token)AbstractNodeFactory.createIdentifierToken((String)"graphqlResponse"));
        TypedBindingPatternNode typedBindingPatternNode = NodeFactory.createTypedBindingPatternNode((TypeDescriptorNode)typeDescriptor, (BindingPatternNode)bindingPattern);
        SimpleNameReferenceNode fieldName = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"graphqlClient"));
        FieldAccessExpressionNode graphqlClientFieldAccessExpr = NodeFactory.createFieldAccessExpressionNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"self")), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.DOT_TOKEN), (NameReferenceNode)fieldName);
        SimpleNameReferenceNode methodName = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"executeWithType"));
        ArrayList<Object> arguments = new ArrayList<Object>();
        PositionalArgumentNode queryArgument = NodeFactory.createPositionalArgumentNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"query")));
        PositionalArgumentNode variablesArgument = NodeFactory.createPositionalArgumentNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"variables")));
        NamedArgumentNode httpHeadersArgument = NodeFactory.createNamedArgumentNode((SimpleNameReferenceNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"headers")), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"httpHeaders")));
        arguments.add(queryArgument);
        arguments.add(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
        arguments.add(variablesArgument);
        arguments.add(AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COMMA_TOKEN));
        arguments.add(httpHeadersArgument);
        SeparatedNodeList remoteFunctionArguments = NodeFactory.createSeparatedNodeList(arguments);
        RemoteMethodCallActionNode remoteMethodCallExpr = NodeFactory.createRemoteMethodCallActionNode((ExpressionNode)graphqlClientFieldAccessExpr, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.RIGHT_ARROW_TOKEN), (SimpleNameReferenceNode)methodName, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), (SeparatedNodeList)remoteFunctionArguments, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN));
        CheckExpressionNode initializer = NodeFactory.createCheckExpressionNode(null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CHECK_KEYWORD), (ExpressionNode)remoteMethodCallExpr);
        return NodeFactory.createVariableDeclarationNode((NodeList)annotationNodes, null, (TypedBindingPatternNode)typedBindingPatternNode, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)initializer, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }
}

