/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.graphql.generator.client.generator.graphql.components;

import graphql.language.Argument;
import graphql.language.Field;
import graphql.language.Selection;
import graphql.language.SelectionSet;
import io.ballerina.graphql.generator.client.generator.graphql.components.ExtendedArgumentDefinition;
import java.util.ArrayList;
import java.util.List;

public class ExtendedFieldDefinition {
    private final Field definition;

    public ExtendedFieldDefinition(Field definition) {
        this.definition = definition;
    }

    public String getAlias() {
        return this.definition.getAlias();
    }

    public String getName() {
        return this.definition.getName();
    }

    public List<ExtendedArgumentDefinition> getArguments() {
        ArrayList<ExtendedArgumentDefinition> extendedArgumentDefinitions = new ArrayList<ExtendedArgumentDefinition>();
        for (Argument argument : this.definition.getArguments()) {
            ExtendedArgumentDefinition argumentDefinition = new ExtendedArgumentDefinition(argument);
            extendedArgumentDefinitions.add(argumentDefinition);
        }
        return extendedArgumentDefinitions;
    }

    public SelectionSet getSelectionSet() {
        return this.definition.getSelectionSet();
    }

    public List<ExtendedFieldDefinition> getExtendedFieldDefinitions() {
        ArrayList<ExtendedFieldDefinition> fieldDefinitionList = new ArrayList<ExtendedFieldDefinition>();
        if (this.definition.getSelectionSet() != null) {
            for (Selection selection : this.definition.getSelectionSet().getSelections()) {
                Field field = (Field)selection;
                ExtendedFieldDefinition extendedFieldDefinition = new ExtendedFieldDefinition(field);
                fieldDefinitionList.add(extendedFieldDefinition);
            }
        }
        return fieldDefinitionList;
    }
}

