/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.graphql.generator.service.exception;

import io.ballerina.graphql.generator.service.diagnostic.ServiceDiagnosticMessages;
import io.ballerina.graphql.generator.utils.NullLocation;
import io.ballerina.tools.diagnostics.Diagnostic;
import io.ballerina.tools.diagnostics.DiagnosticFactory;
import io.ballerina.tools.diagnostics.DiagnosticInfo;
import io.ballerina.tools.diagnostics.Location;

public class ServiceGenerationException
extends Exception {
    private final Diagnostic diagnostic;

    public ServiceGenerationException(ServiceDiagnosticMessages diagnosticMessage, Location location, String ... args) {
        super(diagnosticMessage.getDescription());
        this.diagnostic = DiagnosticFactory.createDiagnostic((DiagnosticInfo)this.generateDiagnosticInfo(diagnosticMessage, args), (Location)this.getLocation(location), (Object[])new Object[0]);
    }

    @Override
    public String getMessage() {
        return this.diagnostic.toString();
    }

    private String generateDescription(ServiceDiagnosticMessages diagnosticMessage, String ... args) {
        return String.format(diagnosticMessage.getDescription(), args);
    }

    private DiagnosticInfo generateDiagnosticInfo(ServiceDiagnosticMessages diagnosticMessage, String ... args) {
        return new DiagnosticInfo(diagnosticMessage.getCode(), this.generateDescription(diagnosticMessage, args), diagnosticMessage.getSeverity());
    }

    private Location getLocation(Location location) {
        if (location == null) {
            return NullLocation.getInstance();
        }
        return location;
    }
}

