/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.graphql.generator.service.generator;

import graphql.schema.GraphQLSchema;
import io.ballerina.compiler.syntax.tree.MethodDeclarationNode;
import io.ballerina.graphql.generator.CodeGenerator;
import io.ballerina.graphql.generator.GraphqlProject;
import io.ballerina.graphql.generator.service.diagnostic.ServiceDiagnosticMessages;
import io.ballerina.graphql.generator.service.exception.ServiceGenerationException;
import io.ballerina.graphql.generator.service.generator.ServiceGenerator;
import io.ballerina.graphql.generator.service.generator.ServiceTypesGenerator;
import io.ballerina.graphql.generator.utils.SrcFilePojo;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

public class ServiceCodeGenerator
extends CodeGenerator {
    private ServiceGenerator serviceGenerator = new ServiceGenerator();
    private ServiceTypesGenerator serviceTypesGenerator = new ServiceTypesGenerator();
    private List<MethodDeclarationNode> serviceMethodDeclarations;

    @Override
    public void generate(GraphqlProject project) throws ServiceGenerationException {
        String outputPath = project.getOutputPath();
        try {
            List<SrcFilePojo> genSources = this.generateBalSources(project);
            this.writeGeneratedSources(genSources, Path.of(outputPath, new String[0]));
        }
        catch (IOException e) {
            throw new ServiceGenerationException(ServiceDiagnosticMessages.GRAPHQL_SERVICE_GEN_100, null, e.getMessage());
        }
    }

    public List<SrcFilePojo> generateBalSources(GraphqlProject project) throws ServiceGenerationException {
        String projectName = project.getName();
        String fileName = project.getFileName();
        GraphQLSchema graphQLSchema = project.getGraphQLSchema();
        ArrayList<SrcFilePojo> sourceFiles = new ArrayList<SrcFilePojo>();
        this.generateServiceTypes(projectName, fileName, graphQLSchema, sourceFiles);
        this.generateServices(projectName, fileName, sourceFiles);
        return sourceFiles;
    }

    private void generateServices(String projectName, String fileName, List<SrcFilePojo> sourceFiles) throws ServiceGenerationException {
        this.serviceGenerator.setFileName(fileName);
        this.serviceGenerator.setMethodDeclarations(this.serviceMethodDeclarations);
        String serviceSrc = this.serviceGenerator.generateSrc();
        sourceFiles.add(new SrcFilePojo(SrcFilePojo.GenFileType.GEN_SRC, projectName, "service.bal", serviceSrc));
    }

    private void generateServiceTypes(String projectName, String fileName, GraphQLSchema graphQLSchema, List<SrcFilePojo> sourceFiles) throws ServiceGenerationException {
        this.serviceTypesGenerator.setFileName(fileName);
        String typesFileContent = this.serviceTypesGenerator.generateSrc(graphQLSchema);
        this.setServiceMethodDeclarations(this.serviceTypesGenerator.getServiceMethodDeclarations());
        sourceFiles.add(new SrcFilePojo(SrcFilePojo.GenFileType.MODEL_SRC, projectName, "types.bal", typesFileContent));
    }

    public void enableToUseRecords() {
        this.serviceTypesGenerator.setUseRecordsForObjects(true);
    }

    public void setServiceMethodDeclarations(List<MethodDeclarationNode> serviceMethodDeclarations) {
        this.serviceMethodDeclarations = serviceMethodDeclarations;
    }
}

