/*
 * Decompiled with CFR 0.152.
 */
package io.ballerina.graphql.generator.service.generator;

import io.ballerina.compiler.syntax.tree.AbstractNodeFactory;
import io.ballerina.compiler.syntax.tree.BasicLiteralNode;
import io.ballerina.compiler.syntax.tree.BindingPatternNode;
import io.ballerina.compiler.syntax.tree.ExplicitNewExpressionNode;
import io.ballerina.compiler.syntax.tree.ExpressionNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyBlockNode;
import io.ballerina.compiler.syntax.tree.FunctionBodyNode;
import io.ballerina.compiler.syntax.tree.FunctionDefinitionNode;
import io.ballerina.compiler.syntax.tree.FunctionSignatureNode;
import io.ballerina.compiler.syntax.tree.IdentifierToken;
import io.ballerina.compiler.syntax.tree.ImportDeclarationNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationLineNode;
import io.ballerina.compiler.syntax.tree.MarkdownDocumentationNode;
import io.ballerina.compiler.syntax.tree.MetadataNode;
import io.ballerina.compiler.syntax.tree.MethodDeclarationNode;
import io.ballerina.compiler.syntax.tree.Minutiae;
import io.ballerina.compiler.syntax.tree.MinutiaeList;
import io.ballerina.compiler.syntax.tree.ModuleMemberDeclarationNode;
import io.ballerina.compiler.syntax.tree.ModulePartNode;
import io.ballerina.compiler.syntax.tree.ModuleVariableDeclarationNode;
import io.ballerina.compiler.syntax.tree.Node;
import io.ballerina.compiler.syntax.tree.NodeFactory;
import io.ballerina.compiler.syntax.tree.NodeList;
import io.ballerina.compiler.syntax.tree.ParenthesizedArgList;
import io.ballerina.compiler.syntax.tree.PositionalArgumentNode;
import io.ballerina.compiler.syntax.tree.QualifiedNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SeparatedNodeList;
import io.ballerina.compiler.syntax.tree.ServiceDeclarationNode;
import io.ballerina.compiler.syntax.tree.SimpleNameReferenceNode;
import io.ballerina.compiler.syntax.tree.SyntaxKind;
import io.ballerina.compiler.syntax.tree.SyntaxTree;
import io.ballerina.compiler.syntax.tree.Token;
import io.ballerina.compiler.syntax.tree.TypeDescriptorNode;
import io.ballerina.compiler.syntax.tree.TypedBindingPatternNode;
import io.ballerina.graphql.generator.service.diagnostic.ServiceDiagnosticMessages;
import io.ballerina.graphql.generator.service.exception.ServiceGenerationException;
import io.ballerina.graphql.generator.utils.CodeGeneratorUtils;
import io.ballerina.tools.text.TextDocument;
import io.ballerina.tools.text.TextDocuments;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.ballerinalang.formatter.core.Formatter;
import org.ballerinalang.formatter.core.FormatterException;

public class ServiceGenerator {
    private String fileName;
    private List<MethodDeclarationNode> methodDeclarations;

    public ModulePartNode generateContentNode() {
        NodeList<ImportDeclarationNode> imports = CodeGeneratorUtils.generateImports();
        NodeList<ModuleMemberDeclarationNode> serviceBody = this.generateMembers();
        return NodeFactory.createModulePartNode(imports, serviceBody, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EOF_TOKEN));
    }

    private SyntaxTree generateSyntaxTree() throws IOException {
        ModulePartNode modulePartNode = this.generateContentNode();
        TextDocument textDocument = TextDocuments.from((String)"");
        SyntaxTree syntaxTree = SyntaxTree.from((TextDocument)textDocument);
        return syntaxTree.modifyWith((Node)modulePartNode);
    }

    private NodeList<ModuleMemberDeclarationNode> generateMembers() {
        ArrayList<Object> members = new ArrayList<Object>();
        ModuleVariableDeclarationNode portVariable = this.generatePortModuleVariableDeclaration("9090");
        members.add(portVariable);
        ServiceDeclarationNode serviceDeclaration = this.generateServiceDeclaration();
        members.add(serviceDeclaration);
        return AbstractNodeFactory.createNodeList(members);
    }

    private ModuleVariableDeclarationNode generatePortModuleVariableDeclaration(String portNumberStr) {
        NodeList configurableQualifier = AbstractNodeFactory.createNodeList((Node[])new Token[]{AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CONFIGURABLE_KEYWORD)});
        TypedBindingPatternNode portTypeBinding = NodeFactory.createTypedBindingPatternNode((TypeDescriptorNode)NodeFactory.createBuiltinSimpleNameReferenceNode(null, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.INT_KEYWORD)), (BindingPatternNode)NodeFactory.createCaptureBindingPatternNode((Token)AbstractNodeFactory.createIdentifierToken((String)"port")));
        BasicLiteralNode portNumber = NodeFactory.createBasicLiteralNode((SyntaxKind)SyntaxKind.NUMERIC_LITERAL, (Token)AbstractNodeFactory.createIdentifierToken((String)portNumberStr));
        return NodeFactory.createModuleVariableDeclarationNode(null, null, (NodeList)configurableQualifier, (TypedBindingPatternNode)portTypeBinding, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.EQUAL_TOKEN), (ExpressionNode)portNumber, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SEMICOLON_TOKEN));
    }

    private ServiceDeclarationNode generateServiceDeclaration() {
        NodeList qualifiers = AbstractNodeFactory.createEmptyNodeList();
        SimpleNameReferenceNode fileName = NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)this.fileName));
        NodeList absoluteResourcePath = AbstractNodeFactory.createEmptyNodeList();
        ExplicitNewExpressionNode graphqlListener = this.generateGraphqlListener();
        NodeList<Node> functionDefinitions = this.generateServiceFunctionDefinitions();
        return NodeFactory.createServiceDeclarationNode(null, (NodeList)qualifiers, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.SERVICE_KEYWORD), (TypeDescriptorNode)fileName, (NodeList)absoluteResourcePath, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.ON_KEYWORD), (SeparatedNodeList)AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[]{graphqlListener}), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), functionDefinitions, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN), null);
    }

    private NodeList<Node> generateServiceFunctionDefinitions() {
        ArrayList<FunctionDefinitionNode> functionDefinitions = new ArrayList<FunctionDefinitionNode>();
        for (int methodDeclarationInd = 0; methodDeclarationInd < this.methodDeclarations.size(); ++methodDeclarationInd) {
            MethodDeclarationNode methodDeclaration = this.methodDeclarations.get(methodDeclarationInd);
            MetadataNode methodDeclarationMetadata = methodDeclaration.metadata().orElse(null);
            methodDeclarationMetadata = this.modifyMetadataForServiceFunctionDefinition(methodDeclarationMetadata, methodDeclarationInd);
            NodeList<Token> finalQualifiers = this.modifyMethodDeclarationQualifiersForServiceFunctionDefinition((NodeList<Token>)methodDeclaration.qualifierList(), methodDeclarationInd, methodDeclarationMetadata);
            FunctionBodyBlockNode emptyFunctionBody = NodeFactory.createFunctionBodyBlockNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_BRACE_TOKEN), null, (NodeList)AbstractNodeFactory.createEmptyNodeList(), (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_BRACE_TOKEN, (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList(), (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList()), null);
            FunctionDefinitionNode functionDefinition = NodeFactory.createFunctionDefinitionNode((SyntaxKind)this.getDefinitionKindFromDeclarationKind(methodDeclaration.kind()), (MetadataNode)methodDeclarationMetadata, finalQualifiers, (Token)methodDeclaration.functionKeyword(), (IdentifierToken)methodDeclaration.methodName(), (NodeList)methodDeclaration.relativeResourcePath(), (FunctionSignatureNode)methodDeclaration.methodSignature(), (FunctionBodyNode)emptyFunctionBody);
            functionDefinitions.add(functionDefinition);
        }
        return AbstractNodeFactory.createNodeList(functionDefinitions);
    }

    private NodeList<Token> modifyMethodDeclarationQualifiersForServiceFunctionDefinition(NodeList<Token> qualifierList, int methodDeclarationInd, MetadataNode methodDeclarationMetadata) {
        if (methodDeclarationInd != 0 && methodDeclarationMetadata == null) {
            MinutiaeList leadingMinutiaeList = AbstractNodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{AbstractNodeFactory.createCommentMinutiae((String)"\n")});
            Token firstQualifier = (Token)qualifierList.get(0);
            qualifierList = qualifierList.remove(0);
            Token newLineAddedFirstQualifier = firstQualifier.modify(leadingMinutiaeList, AbstractNodeFactory.createEmptyMinutiaeList());
            qualifierList = qualifierList.add(0, (Node)newLineAddedFirstQualifier);
        }
        return qualifierList;
    }

    private MetadataNode modifyMetadataForServiceFunctionDefinition(MetadataNode methodDeclarationMetadata, int methodDeclarationInd) {
        if (methodDeclarationInd == 0 || methodDeclarationMetadata == null) {
            return methodDeclarationMetadata;
        }
        return ServiceGenerator.addNewLineInFrontOfMetadata(methodDeclarationMetadata);
    }

    public static MetadataNode addNewLineInFrontOfMetadata(MetadataNode metadata) {
        MarkdownDocumentationNode markdownDocumentation;
        NodeList documentationLines;
        Node firstDocumentationLine;
        Node documentationString = metadata.documentationString().orElse(null);
        if (documentationString.kind() == SyntaxKind.MARKDOWN_DOCUMENTATION && (firstDocumentationLine = (documentationLines = (markdownDocumentation = (MarkdownDocumentationNode)documentationString).documentationLines()).get(0)).kind() == SyntaxKind.MARKDOWN_DOCUMENTATION_LINE) {
            MarkdownDocumentationLineNode firstMarkdownDocumentationLine = (MarkdownDocumentationLineNode)firstDocumentationLine;
            Token firstLineHash = firstMarkdownDocumentationLine.hashToken();
            return (MetadataNode)metadata.replace((Node)firstLineHash, (Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.HASH_TOKEN, (MinutiaeList)AbstractNodeFactory.createMinutiaeList((Minutiae[])new Minutiae[]{AbstractNodeFactory.createCommentMinutiae((String)"\n")}), (MinutiaeList)AbstractNodeFactory.createEmptyMinutiaeList()));
        }
        return metadata;
    }

    private SyntaxKind getDefinitionKindFromDeclarationKind(SyntaxKind declarationKind) {
        if (SyntaxKind.RESOURCE_ACCESSOR_DECLARATION.equals((Object)declarationKind)) {
            return SyntaxKind.RESOURCE_ACCESSOR_DEFINITION;
        }
        if (SyntaxKind.METHOD_DECLARATION.equals((Object)declarationKind)) {
            return SyntaxKind.OBJECT_METHOD_DEFINITION;
        }
        return null;
    }

    private ExplicitNewExpressionNode generateGraphqlListener() {
        QualifiedNameReferenceNode graphqlListenerName = NodeFactory.createQualifiedNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"graphql"), (Node)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.COLON_TOKEN), (IdentifierToken)AbstractNodeFactory.createIdentifierToken((String)"Listener"));
        PositionalArgumentNode argumentPort = NodeFactory.createPositionalArgumentNode((ExpressionNode)NodeFactory.createSimpleNameReferenceNode((Token)AbstractNodeFactory.createIdentifierToken((String)"port")));
        SeparatedNodeList arguments = AbstractNodeFactory.createSeparatedNodeList((Node[])new Node[]{argumentPort});
        ParenthesizedArgList parenthesizedArguments = NodeFactory.createParenthesizedArgList((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.OPEN_PAREN_TOKEN), (SeparatedNodeList)arguments, (Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.CLOSE_PAREN_TOKEN));
        return NodeFactory.createExplicitNewExpressionNode((Token)AbstractNodeFactory.createToken((SyntaxKind)SyntaxKind.NEW_KEYWORD), (TypeDescriptorNode)graphqlListenerName, (ParenthesizedArgList)parenthesizedArguments);
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public void setMethodDeclarations(List<MethodDeclarationNode> methodDeclarations) {
        this.methodDeclarations = methodDeclarations;
    }

    public String generateSrc() throws ServiceGenerationException {
        try {
            String generatedSyntaxTree = Formatter.format((SyntaxTree)this.generateSyntaxTree()).toString();
            return Formatter.format((String)generatedSyntaxTree);
        }
        catch (IOException | FormatterException e) {
            throw new ServiceGenerationException(ServiceDiagnosticMessages.GRAPHQL_SERVICE_GEN_101, null, e.getMessage());
        }
    }
}

